/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.arbitraries.CharacterArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.DefaultCharacterArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableString;

public class DefaultStringArbitrary
extends AbstractArbitraryBase
implements StringArbitrary {
    private CharacterArbitrary characterArbitrary = new DefaultCharacterArbitrary();
    private int minLength = 0;
    private int maxLength = 255;

    public RandomGenerator<String> generator(int genSize) {
        int cutoffLength = RandomGenerators.defaultCutoffSize(this.minLength, this.maxLength, genSize);
        return RandomGenerators.strings(this.randomCharacterGenerator(), this.minLength, this.maxLength, cutoffLength).withEdgeCases(genSize, this.edgeCases());
    }

    public Optional<ExhaustiveGenerator<String>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.strings((Arbitrary<Character>)this.characterArbitrary, this.minLength, this.maxLength, maxNumberOfSamples);
    }

    public EdgeCases<String> edgeCases() {
        EdgeCases<String> emptyStringEdgeCases = this.hasEmptyStringEdgeCase() ? this.emptyStringEdgeCase() : EdgeCases.none();
        EdgeCases<String> singleCharEdgeCases = this.hasSingleCharEdgeCases() ? this.fixedSizedEdgeCases(1) : EdgeCases.none();
        EdgeCases<String> fixedSizeEdgeCases = this.hasMultiCharEdgeCases() ? this.fixedSizedEdgeCases(this.minLength) : EdgeCases.none();
        return EdgeCasesSupport.concat(singleCharEdgeCases, emptyStringEdgeCases, fixedSizeEdgeCases);
    }

    private boolean hasEmptyStringEdgeCase() {
        return this.minLength <= 0;
    }

    private boolean hasMultiCharEdgeCases() {
        return this.minLength <= this.maxLength && this.minLength > 1 && !this.characterArbitrary.isUnique();
    }

    private boolean hasSingleCharEdgeCases() {
        return this.minLength <= 1 && this.maxLength >= 1;
    }

    private EdgeCases<String> emptyStringEdgeCase() {
        return EdgeCases.fromSupplier(() -> new ShrinkableString(Collections.emptyList(), this.minLength, this.maxLength));
    }

    private EdgeCases<String> fixedSizedEdgeCases(int fixedSize) {
        return EdgeCasesSupport.mapShrinkable(this.characterArbitrary.edgeCases(), shrinkableChar -> {
            ArrayList<Shrinkable<Character>> chars = new ArrayList<Shrinkable<Character>>(Collections.nCopies(fixedSize, shrinkableChar));
            return new ShrinkableString((List<Shrinkable<Character>>)chars, this.minLength, this.maxLength);
        });
    }

    public StringArbitrary ofMinLength(int minLength) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.minLength = minLength;
        return clone;
    }

    public StringArbitrary ofMaxLength(int maxLength) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.maxLength = maxLength;
        return clone;
    }

    public StringArbitrary withChars(char ... chars) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.with(chars);
        return clone;
    }

    public StringArbitrary withChars(CharSequence chars) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.with(chars);
        return clone;
    }

    public StringArbitrary withChars(Arbitrary<Character> characterArbitrary) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.with(characterArbitrary);
        return clone;
    }

    public StringArbitrary withCharRange(char from, char to) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.range(from, to);
        return clone;
    }

    public StringArbitrary ascii() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = this.characterArbitrary.ascii();
        return clone;
    }

    public StringArbitrary alpha() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.range('A', 'Z').range('a', 'z');
        return clone;
    }

    public StringArbitrary numeric() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.range('0', '9');
        return clone;
    }

    public StringArbitrary whitespace() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.whitespace();
        return clone;
    }

    public StringArbitrary all() {
        return this.withCharRange('\u0000', '\uffff');
    }

    private RandomGenerator<Character> randomCharacterGenerator() {
        return this.characterArbitrary.generator(1);
    }
}

