/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.arbitraries.StreamableArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.ArbitrariesSupport;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableList;

abstract class MultivalueArbitraryBase<T, U>
extends AbstractArbitraryBase
implements StreamableArbitrary<T, U> {
    protected Arbitrary<T> elementArbitrary;
    protected int minSize = 0;
    protected int maxSize = 255;
    private final boolean elementsUnique;

    protected MultivalueArbitraryBase(Arbitrary<T> elementArbitrary, boolean elementsUnique) {
        this.elementArbitrary = elementArbitrary;
        this.elementsUnique = elementsUnique;
        if (elementsUnique) {
            this.maxSize = ArbitrariesSupport.maxNumberOfElements(elementArbitrary, 255);
        }
    }

    public StreamableArbitrary<T, U> ofMinSize(int minSize) {
        MultivalueArbitraryBase clone = (MultivalueArbitraryBase)this.typedClone();
        clone.minSize = minSize;
        return clone;
    }

    public StreamableArbitrary<T, U> ofMaxSize(int maxSize) {
        MultivalueArbitraryBase clone = (MultivalueArbitraryBase)this.typedClone();
        clone.maxSize = maxSize;
        return clone;
    }

    public <R> Arbitrary<R> reduce(R initial, BiFunction<R, T, R> accumulator) {
        return this.map(streamable -> {
            Object[] result = new Object[]{initial};
            Iterable<T> iterable = this.toIterable(streamable);
            for (T each : iterable) {
                result[0] = accumulator.apply(result[0], each);
            }
            return result[0];
        });
    }

    protected abstract Iterable<T> toIterable(U var1);

    protected RandomGenerator<List<T>> createListGenerator(int genSize) {
        RandomGenerator<T> elementGenerator = this.elementGenerator(this.elementArbitrary, genSize);
        EdgeCases edgeCases = this.edgeCases((elements, minSize1) -> new ShrinkableList(elements, (int)minSize1, this.maxSize));
        return RandomGenerators.list(elementGenerator, this.minSize, this.maxSize, this.cutoffSize(genSize)).withEdgeCases(genSize, edgeCases);
    }

    protected int cutoffSize(int genSize) {
        return RandomGenerators.defaultCutoffSize(this.minSize, this.maxSize, genSize);
    }

    protected RandomGenerator<T> elementGenerator(Arbitrary<T> elementArbitrary, int genSize) {
        return elementArbitrary.generator(genSize);
    }

    protected <C extends Collection<?>> EdgeCases<C> edgeCases(BiFunction<List<Shrinkable<T>>, Integer, Shrinkable<C>> shrinkableCreator) {
        EdgeCases<C> emptyListEdgeCase = this.minSize == 0 ? this.emptyListEdgeCase(shrinkableCreator) : EdgeCases.none();
        EdgeCases<C> singleElementEdgeCases = this.minSize <= 1 && this.maxSize >= 1 ? this.fixedSizeEdgeCases(1, shrinkableCreator) : EdgeCases.none();
        EdgeCases<C> fixedSizeEdgeCases = this.generateFixedSizeEdgeCases() ? this.fixedSizeEdgeCases(this.minSize, shrinkableCreator) : EdgeCases.none();
        return EdgeCasesSupport.concat(Arrays.asList(emptyListEdgeCase, singleElementEdgeCases, fixedSizeEdgeCases));
    }

    private boolean generateFixedSizeEdgeCases() {
        if (this.elementsUnique) {
            return false;
        }
        return this.minSize == this.maxSize && this.minSize > 1;
    }

    private <C extends Collection<?>> EdgeCases<C> fixedSizeEdgeCases(int fixedSize, BiFunction<List<Shrinkable<T>>, Integer, Shrinkable<C>> shrinkableCreator) {
        return EdgeCasesSupport.mapShrinkable(this.elementArbitrary.edgeCases(), shrinkableT -> {
            ArrayList<Shrinkable> elements = new ArrayList<Shrinkable>(Collections.nCopies(fixedSize, shrinkableT));
            return (Shrinkable)shrinkableCreator.apply(elements, this.minSize);
        });
    }

    private <C extends Collection<?>> EdgeCases<C> emptyListEdgeCase(BiFunction<List<Shrinkable<T>>, Integer, Shrinkable<C>> shrinkableCreator) {
        return EdgeCases.fromSupplier(() -> (Shrinkable)shrinkableCreator.apply(Collections.emptyList(), this.minSize));
    }
}

