/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.io.Serializable;
import java.util.Objects;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.RandomGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class WildcardArbitrary
implements Arbitrary<Object> {
    public RandomGenerator<Object> generator(int genSize) {
        return RandomGenerators.integers(0, genSize / 2).map(WildcardObject::new);
    }

    public EdgeCases<Object> edgeCases() {
        return EdgeCases.none();
    }

    public static class WildcardObject
    implements Comparable<WildcardObject>,
    Serializable {
        private final Integer index;

        public WildcardObject(Integer index) {
            this.index = index;
        }

        public String toString() {
            return String.format("Any[%d]", this.index);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WildcardObject that = (WildcardObject)o;
            return Objects.equals(this.index, that.index);
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        @Override
        public int compareTo(WildcardObject o) {
            return Integer.compare(this.index, o.index);
        }
    }
}

