/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.MaxTriesLoop;

public class UniqueExhaustiveGenerator<T>
implements ExhaustiveGenerator<T> {
    private final ExhaustiveGenerator<T> base;

    public UniqueExhaustiveGenerator(ExhaustiveGenerator<T> base) {
        this.base = base;
    }

    public long maxCount() {
        return this.base.maxCount();
    }

    public Iterator<T> iterator() {
        final Iterator mappedIterator = this.base.iterator();
        final ConcurrentHashMap.KeySetView usedValues = ConcurrentHashMap.newKeySet();
        return new Iterator<T>(){
            T next = this.findNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = this.findNext();
                return result;
            }

            private T findNext() {
                return MaxTriesLoop.loop(() -> true, next -> {
                    if (!mappedIterator.hasNext()) {
                        return Tuple.of((Object)true, null);
                    }
                    next = mappedIterator.next();
                    if (!usedValues.contains(next)) {
                        usedValues.add(next);
                        return Tuple.of((Object)true, (Object)next);
                    }
                    return Tuple.of((Object)false, (Object)next);
                }, maxMisses -> {
                    String message = String.format("Uniqueness filter missed more than %s times.", maxMisses);
                    return new TooManyFilterMissesException(message);
                });
            }
        };
    }
}

