/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.FalsifiedSample;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.engine.properties.FalsifiedSampleImpl;

abstract class AbstractSampleShrinker {
    private final Map<List<Object>, TryExecutionResult> falsificationCache;

    private static ShrinkingDistance calculateDistance(List<Shrinkable<Object>> shrinkables) {
        return ShrinkingDistance.forCollection(shrinkables);
    }

    public AbstractSampleShrinker(Map<List<Object>, TryExecutionResult> falsificationCache) {
        this.falsificationCache = falsificationCache;
    }

    public abstract FalsifiedSample shrink(Falsifier<List<Object>> var1, FalsifiedSample var2, Consumer<FalsifiedSample> var3, Consumer<FalsifiedSample> var4);

    protected FalsifiedSample shrink(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> shrinkSampleConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer, Function<List<Shrinkable<Object>>, Stream<List<Shrinkable<Object>>>> supplyShrinkCandidates) {
        List currentShrinkBase = sample.shrinkables();
        Optional<Object> bestResult = Optional.empty();
        FilteredResults filteredResults = new FilteredResults();
        while (true) {
            ShrinkingDistance currentDistance = AbstractSampleShrinker.calculateDistance(currentShrinkBase);
            FalsifiedSample currentBest = bestResult.orElse(null);
            Optional<Tuple.Tuple3> newShrinkingResult = supplyShrinkCandidates.apply(currentShrinkBase).peek(ignore -> shrinkAttemptConsumer.accept(currentBest)).filter(shrinkables -> AbstractSampleShrinker.calculateDistance(shrinkables).compareTo(currentDistance) <= 0).map(shrinkables -> {
                List<Object> params = this.createValues((List<Shrinkable<Object>>)shrinkables).collect(Collectors.toList());
                TryExecutionResult result = this.falsify(falsifier, params);
                return Tuple.of(params, (Object)shrinkables, (Object)result);
            }).peek(t -> {
                if (((TryExecutionResult)t.get3()).isInvalid() && AbstractSampleShrinker.calculateDistance((List)t.get2()).compareTo(currentDistance) < 0) {
                    filteredResults.push((Tuple.Tuple3<List<Object>, List<Shrinkable<Object>>, TryExecutionResult>)t);
                }
            }).filter(t -> ((TryExecutionResult)t.get3()).isFalsified()).findAny();
            if (newShrinkingResult.isPresent()) {
                Tuple.Tuple3 falsifiedTry = newShrinkingResult.get();
                FalsifiedSampleImpl falsifiedSample = new FalsifiedSampleImpl((List)falsifiedTry.get1(), (List)falsifiedTry.get2(), ((TryExecutionResult)falsifiedTry.get3()).throwable());
                shrinkSampleConsumer.accept(falsifiedSample);
                bestResult = Optional.of(falsifiedSample);
                currentShrinkBase = (List)falsifiedTry.get2();
                filteredResults.clear();
                continue;
            }
            if (filteredResults.isEmpty()) break;
            Tuple.Tuple3<List<Object>, List<Shrinkable<Object>>, TryExecutionResult> aFilteredResult = filteredResults.pop();
            currentShrinkBase = (List)aFilteredResult.get2();
        }
        return bestResult.orElse(sample);
    }

    private TryExecutionResult falsify(Falsifier<List<Object>> falsifier, List<Object> params) {
        return this.falsificationCache.computeIfAbsent(params, p -> falsifier.execute((Object)params));
    }

    private Stream<Object> createValues(List<Shrinkable<Object>> shrinkables) {
        return shrinkables.stream().map(Shrinkable::value);
    }

    private static class FilteredResults {
        public static final int MAX_SIZE = 100;
        Comparator<? super Tuple.Tuple3<List<Object>, List<Shrinkable<Object>>, TryExecutionResult>> resultComparator = Comparator.comparing(left -> AbstractSampleShrinker.access$100((List)left.get2()));
        PriorityQueue<Tuple.Tuple3<List<Object>, List<Shrinkable<Object>>, TryExecutionResult>> prioritizedResults = new PriorityQueue<Tuple.Tuple3<List<Object>, List<Shrinkable<Object>>, TryExecutionResult>>(this.resultComparator);
        Set<Tuple.Tuple3<List<Object>, List<Shrinkable<Object>>, TryExecutionResult>> removedResults = new HashSet<Tuple.Tuple3<List<Object>, List<Shrinkable<Object>>, TryExecutionResult>>();

        private FilteredResults() {
        }

        void push(Tuple.Tuple3<List<Object>, List<Shrinkable<Object>>, TryExecutionResult> result) {
            if (this.removedResults.contains(result)) {
                return;
            }
            this.prioritizedResults.add(result);
            if (this.size() > 100) {
                this.prioritizedResults.poll();
            }
        }

        int size() {
            return this.prioritizedResults.size();
        }

        boolean isEmpty() {
            return this.prioritizedResults.isEmpty();
        }

        Tuple.Tuple3<List<Object>, List<Shrinkable<Object>>, TryExecutionResult> pop() {
            Tuple.Tuple3<List<Object>, List<Shrinkable<Object>>, TryExecutionResult> result = this.prioritizedResults.peek();
            this.prioritizedResults.remove(result);
            this.removedResults.add(result);
            return result;
        }

        public void clear() {
            this.prioritizedResults.clear();
            this.removedResults.clear();
        }
    }
}

