/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;

class BigIntegerGrower {
    BigIntegerGrower() {
    }

    Optional<Shrinkable<BigInteger>> grow(BigInteger value, Range<BigInteger> range, BigInteger shrinkingTarget, Shrinkable<?> before, Shrinkable<?> after) {
        BigInteger grownValue;
        Object afterValue;
        Object beforeValue = before.value();
        BigInteger diff = this.calculateDiff(beforeValue, afterValue = after.value());
        if (diff.compareTo(BigInteger.ZERO) != 0 && range.includes(grownValue = value.add(diff))) {
            return Optional.of(new ShrinkableBigInteger(grownValue, range, shrinkingTarget));
        }
        return Optional.empty();
    }

    private BigInteger calculateDiff(Object beforeValue, Object afterValue) {
        if (beforeValue instanceof BigInteger && afterValue instanceof BigInteger) {
            return ((BigInteger)beforeValue).subtract((BigInteger)afterValue);
        }
        return BigInteger.valueOf(this.toLong(beforeValue) - this.toLong(afterValue));
    }

    private long toLong(Object value) {
        return this.tryNumberTypeCasts(value, Integer.class, Long.class, Short.class, Byte.class);
    }

    private long tryNumberTypeCasts(Object value, Class<?> ... targetClasses) {
        return this.tryNumberTypeCasts(value, new ArrayList(Arrays.asList(targetClasses)));
    }

    private long tryNumberTypeCasts(Object value, List<Class<?>> targetClasses) {
        if (targetClasses.isEmpty()) {
            return 0L;
        }
        try {
            Class<?> targetClass = targetClasses.remove(0);
            return ((Number)targetClass.cast(value)).longValue();
        }
        catch (Throwable cannotCastToTargetClass) {
            return this.tryNumberTypeCasts(value, targetClasses);
        }
    }

    public Stream<Shrinkable<BigInteger>> grow(BigInteger value, Range<BigInteger> range, BigInteger shrinkingTarget) {
        if (value.compareTo(shrinkingTarget) < 0) {
            return this.growLeft(value, range, shrinkingTarget);
        }
        return this.growRight(value, range, shrinkingTarget);
    }

    private Stream<Shrinkable<BigInteger>> growRight(BigInteger value, Range<BigInteger> range, BigInteger shrinkingTarget) {
        return Stream.of(value.add(BigInteger.ONE), value.add(BigInteger.TEN), ((BigInteger)range.max).divide(BigInteger.valueOf(2L)), (BigInteger)range.max).filter(range::includes).map(grown -> new ShrinkableBigInteger((BigInteger)grown, range, shrinkingTarget));
    }

    private Stream<Shrinkable<BigInteger>> growLeft(BigInteger value, Range<BigInteger> range, BigInteger shrinkingTarget) {
        return Stream.of(value.subtract(BigInteger.ONE), value.subtract(BigInteger.TEN), ((BigInteger)range.min).divide(BigInteger.valueOf(2L)), (BigInteger)range.min).filter(range::includes).map(grown -> new ShrinkableBigInteger((BigInteger)grown, range, shrinkingTarget));
    }
}

