/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.providers;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.JqwikException;
import net.jqwik.api.arbitraries.EmailArbitrary;
import net.jqwik.api.constraints.Email;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;

public class EmailArbitraryProvider
implements ArbitraryProvider {
    public boolean canProvideFor(TypeUsage targetType) {
        return targetType.isAssignableFrom(String.class) && targetType.findAnnotation(Email.class).isPresent();
    }

    public Set<Arbitrary<?>> provideFor(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
        Optional optionalEmail = targetType.findAnnotation(Email.class);
        return optionalEmail.map(email -> {
            this.checkValidEmailConfiguration((Email)email);
            EmailArbitrary emailArbitrary = Arbitraries.emails();
            if (email.quotedLocalPart()) {
                emailArbitrary = emailArbitrary.quotedLocalPart();
            }
            if (email.unquotedLocalPart()) {
                emailArbitrary = emailArbitrary.unquotedLocalPart();
            }
            if (email.domainHost()) {
                emailArbitrary = emailArbitrary.domainHost();
            }
            if (email.ipv4Host()) {
                emailArbitrary = emailArbitrary.ipv4Host();
            }
            if (email.ipv6Host()) {
                emailArbitrary = emailArbitrary.ipv6Host();
            }
            return Collections.singleton(emailArbitrary);
        }).orElse(Collections.emptySet());
    }

    public void checkValidEmailConfiguration(Email email) {
        if (!email.quotedLocalPart() && !email.unquotedLocalPart()) {
            String message = "Email addresses require a quoted or unquoted local part.";
            throw new JqwikException(message);
        }
        if (!(email.domainHost() || email.ipv4Host() || email.ipv6Host())) {
            String message = "Email addresses require some kind of host.";
            throw new JqwikException(message);
        }
    }

    public int priority() {
        return 5;
    }
}

