/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.providers;

import java.util.Collections;
import java.util.Set;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.arbitraries.WildcardArbitrary;

public class WildcardArbitraryProvider
implements ArbitraryProvider {
    public boolean canProvideFor(TypeUsage targetType) {
        if (!targetType.isWildcard()) {
            return false;
        }
        return this.hasNoUpperBoundOtherThanObject(targetType) && targetType.getLowerBounds().isEmpty();
    }

    private boolean hasNoUpperBoundOtherThanObject(TypeUsage targetType) {
        return targetType.getUpperBounds().size() != 1 || ((TypeUsage)targetType.getUpperBounds().get(0)).isOfType(Object.class);
    }

    public Set<Arbitrary<?>> provideFor(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
        return Collections.singleton(new WildcardArbitrary());
    }

    public int priority() {
        return 100;
    }
}

