/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.recording;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jqwik.engine.recording.TestRun;
import net.jqwik.engine.recording.TestRunData;
import net.jqwik.engine.recording.TestRunRecorder;

public class TestRunDatabase {
    private static final Logger LOG = Logger.getLogger(TestRunDatabase.class.getName());
    private final Path databasePath;
    private final TestRunData previousRunData;
    private boolean stopRecording = false;

    public TestRunDatabase(Path databasePath) {
        this.databasePath = databasePath;
        this.previousRunData = this.loadExistingRunData();
    }

    private TestRunData loadExistingRunData() {
        TestRunData testRunData;
        block9: {
            if (!Files.exists(this.databasePath, new LinkOption[0])) {
                return new TestRunData();
            }
            ObjectInputStream ois = this.createObjectInputStream();
            try {
                List<TestRun> data = this.readAllTestRuns(ois);
                testRunData = new TestRunData(data);
                if (ois == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logReadException(e);
                    this.deleteDatabase();
                    return new TestRunData();
                }
            }
            ois.close();
        }
        return testRunData;
    }

    private void deleteDatabase() {
        try {
            Files.delete(this.databasePath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<TestRun> readAllTestRuns(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ArrayList<TestRun> testRuns = new ArrayList<TestRun>();
        try {
            while (true) {
                TestRun testRun = (TestRun)ois.readObject();
                testRuns.add(testRun);
            }
        }
        catch (EOFException eof) {
        }
        catch (IOException eof) {
            this.logReadException(eof);
            this.deleteDatabase();
        }
        return testRuns;
    }

    private void logReadException(Exception eof) {
        LOG.log(Level.WARNING, eof, () -> String.format("Cannot read database [%s]", this.databasePath.toAbsolutePath()));
    }

    private void logWriteException(Exception e) {
        LOG.log(Level.WARNING, e, () -> String.format("Cannot write database [%s]", this.databasePath.toAbsolutePath()));
    }

    private ObjectOutputStream createObjectOutputStream() {
        try {
            return new ObjectOutputStream(Files.newOutputStream(this.databasePath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
        }
        catch (IOException e) {
            this.stopRecording = true;
            this.logWriteException(e);
            return null;
        }
    }

    private ObjectInputStream createObjectInputStream() throws IOException {
        return new ObjectInputStream(Files.newInputStream(this.databasePath, StandardOpenOption.CREATE));
    }

    public TestRunData previousRun() {
        return this.previousRunData;
    }

    public TestRunRecorder recorder() {
        return new Recorder(this.createObjectOutputStream());
    }

    private class Recorder
    implements TestRunRecorder {
        private final ObjectOutputStream objectOutputStream;

        private Recorder(ObjectOutputStream objectOutputStream) {
            this.objectOutputStream = objectOutputStream;
        }

        @Override
        public void record(TestRun testRun) {
            this.record(testRun, false);
        }

        private void record(TestRun testRun, boolean secondTry) {
            if (TestRunDatabase.this.stopRecording) {
                return;
            }
            try {
                this.checkSerializability(testRun);
                this.objectOutputStream.writeObject(testRun);
            }
            catch (NotSerializableException e) {
                if (!secondTry) {
                    this.record(testRun.withoutFalsifiedSample(), true);
                } else {
                    TestRunDatabase.this.logWriteException(e);
                }
            }
            catch (IOException e) {
                TestRunDatabase.this.stopRecording = true;
                TestRunDatabase.this.logWriteException(e);
            }
        }

        private void checkSerializability(TestRun testRun) throws IOException {
            ObjectOutputStream testStream = new ObjectOutputStream(new ByteArrayOutputStream());
            testStream.writeObject(testRun);
        }

        @Override
        public void close() {
            try {
                this.objectOutputStream.close();
            }
            catch (IOException e) {
                TestRunDatabase.this.logWriteException(e);
            }
        }
    }
}

