/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class JqwikStreamSupport {
    public static <L, R, T> Stream<T> zip(Stream<L> leftStream, Stream<R> rightStream, final BiFunction<L, R, T> combiner) {
        final Spliterator lefts = leftStream.spliterator();
        final Spliterator rights = rightStream.spliterator();
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.min(lefts.estimateSize(), rights.estimateSize()), lefts.characteristics() & rights.characteristics()){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                return lefts.tryAdvance(left -> rights.tryAdvance(right -> action.accept((Object)combiner.apply(left, right))));
            }
        }, leftStream.isParallel() || rightStream.isParallel());
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Stream<T> ... streams) {
        return JqwikStreamSupport.concat(Arrays.asList(streams));
    }

    public static <T> Stream<T> lazyConcat(List<Supplier<Stream<T>>> suppliers) {
        return suppliers.stream().flatMap(Supplier::get);
    }

    public static <T> Stream<T> concat(List<Stream<T>> streams) {
        return JqwikStreamSupport.concat(Stream.empty(), new ArrayList<Stream<T>>(streams));
    }

    private static <T> Stream<T> concat(Stream<T> head, List<Stream<T>> rest) {
        if (rest.isEmpty()) {
            return head;
        }
        Stream<T> first = rest.remove(0);
        return Stream.concat(head, JqwikStreamSupport.concat(first, rest));
    }

    public static <T> Stream<T> takeWhile(Stream<T> stream, Predicate<? super T> p) {
        class Taking
        extends Spliterators.AbstractSpliterator<T>
        implements Consumer<T> {
            private static final int CANCEL_CHECK_COUNT = 63;
            private final Spliterator<T> s;
            private int count;
            private T t;
            private final AtomicBoolean cancel;
            private boolean takeOrDrop;
            final /* synthetic */ Predicate val$p;

            Taking(Spliterator<T> spliterator) {
                this.val$p = spliterator;
                super(s.estimateSize(), s.characteristics() & 0xFFFFBFBF);
                this.cancel = new AtomicBoolean();
                this.takeOrDrop = true;
                this.s = s;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                boolean test = true;
                if (this.takeOrDrop && (this.count != 0 || !this.cancel.get()) && this.s.tryAdvance(this) && (test = this.val$p.test(this.t))) {
                    action.accept(this.t);
                    return true;
                }
                this.takeOrDrop = false;
                if (!test) {
                    this.cancel.set(true);
                }
                return false;
            }

            @Override
            public Comparator<? super T> getComparator() {
                return this.s.getComparator();
            }

            @Override
            public void accept(T t) {
                this.count = this.count + 1 & 0x3F;
                this.t = t;
            }

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }
        }
        return (Stream)StreamSupport.stream(new Taking(stream.spliterator(), p), stream.isParallel()).onClose(stream::close);
    }
}

