/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;

public class LazyServiceLoaderCache<S> {
    private final Class<S> clz;
    private List<S> services;

    public LazyServiceLoaderCache(Class<S> clz) {
        this.clz = clz;
    }

    public List<S> getServices() {
        if (this.services == null) {
            this.loadServices();
        }
        return this.services;
    }

    private synchronized void loadServices() {
        this.services = new CopyOnWriteArrayList<S>();
        ServiceLoader.load(this.clz).forEach(this.services::add);
    }
}

