/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.api.Label;
import net.jqwik.api.Tag;
import net.jqwik.api.domains.Domain;
import net.jqwik.engine.descriptor.JqwikDescriptor;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;

public class DiscoverySupport {
    private static final Logger LOG = Logger.getLogger(DiscoverySupport.class.getName());

    public static Set<TestTag> findTestTags(AnnotatedElement element) {
        return AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)element, Tag.class).stream().map(Tag::value).filter(tag -> {
            if (!TestTag.isValid((String)tag)) {
                String message = String.format("Invalid tag format in @Tag(\"%s\") on [%s]. Tag will be ignored", tag, element);
                LOG.warning(message);
                return false;
            }
            return true;
        }).map(TestTag::create).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    public static Set<Domain> findDomains(AnnotatedElement element) {
        return new HashSet<Domain>(AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)element, Domain.class));
    }

    public static String determineLabel(AnnotatedElement element, Supplier<String> defaultNameSupplier) {
        return AnnotationSupport.findAnnotation((AnnotatedElement)element, Label.class).map(Label::value).filter(displayName -> !displayName.trim().isEmpty()).orElseGet(DiscoverySupport.readableNameSupplier(defaultNameSupplier));
    }

    private static Supplier<String> readableNameSupplier(Supplier<String> nameSupplier) {
        return () -> ((String)nameSupplier.get()).replaceAll("_", " ");
    }

    public static void warnWhenJunitAnnotationsArePresent(AnnotatedElement element) {
        List<Annotation> junitAnnotations = DiscoverySupport.findJUnitAnnotations(element);
        for (Annotation annotation : junitAnnotations) {
            String message = String.format("[%s] has annotation [%s] from JUnit which cannot be processed by jqwik", element, annotation);
            LOG.warning(message);
        }
    }

    public static List<Annotation> findJUnitAnnotations(AnnotatedElement candidate) {
        return Arrays.stream(candidate.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().getPackage().getName().startsWith("org.junit")).collect(Collectors.toList());
    }

    public static Set<TestTag> getTags(Optional<TestDescriptor> parent, Set<TestTag> tags) {
        LinkedHashSet<TestTag> allTags = new LinkedHashSet<TestTag>(tags);
        parent.ifPresent(parentDescriptor -> allTags.addAll(parentDescriptor.getTags()));
        return allTags;
    }

    public static Set<Domain> getDomains(Optional<JqwikDescriptor> parent, Set<Domain> domains) {
        LinkedHashSet<Domain> allContexts = new LinkedHashSet<Domain>(domains);
        parent.ifPresent(parentDescriptor -> allContexts.addAll(parentDescriptor.getDomains()));
        return allContexts;
    }
}

