/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.reporting;

import java.util.Map;
import java.util.function.BiConsumer;
import net.jqwik.api.Reporter;
import net.jqwik.engine.execution.reporting.BuilderBasedLineReporter;
import net.jqwik.engine.execution.reporting.SampleReporter;
import net.jqwik.engine.execution.reporting.ValueReport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.reporting.ReportEntry;

public class DefaultReporter
implements Reporter {
    private final BiConsumer<TestDescriptor, ReportEntry> listener;
    private final TestDescriptor descriptor;

    public DefaultReporter(BiConsumer<TestDescriptor, ReportEntry> listener, TestDescriptor descriptor) {
        this.listener = listener;
        this.descriptor = descriptor;
    }

    public void publishValue(String key, String value) {
        this.publish(ReportEntry.from((String)key, (String)value));
    }

    public void publishReport(String key, Object object) {
        this.publish(ReportEntry.from((String)key, (String)this.buildReport(object)));
    }

    private String buildReport(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        ValueReport sampleReport = ValueReport.of(object);
        int lengthOfTimestamp = 35;
        if (sampleReport.singleLineLength() < 100 - lengthOfTimestamp) {
            String line = sampleReport.singleLineReport();
            stringBuilder.append(line);
        } else {
            stringBuilder.append(String.format("%n", new Object[0]));
            BuilderBasedLineReporter lineReporter = new BuilderBasedLineReporter(stringBuilder, 0);
            sampleReport.report(lineReporter, 1, "");
        }
        this.removeTrailingNewLine(stringBuilder);
        return stringBuilder.toString();
    }

    public void publishReports(String key, Map<String, Object> objects) {
        this.publish(ReportEntry.from((String)key, (String)this.buildReports(objects)));
    }

    private String buildReports(Map<String, Object> reports) {
        SampleReporter sampleReporter = new SampleReporter(null, reports);
        StringBuilder stringBuilder = new StringBuilder();
        BuilderBasedLineReporter lineReporter = new BuilderBasedLineReporter(stringBuilder, 0);
        sampleReporter.reportTo(lineReporter);
        this.removeTrailingNewLine(stringBuilder);
        return stringBuilder.toString();
    }

    private void publish(ReportEntry entry) {
        this.listener.accept(this.descriptor, entry);
    }

    private void removeTrailingNewLine(StringBuilder stringBuilder) {
        int lastNewLine = stringBuilder.lastIndexOf(String.format("%n", new Object[0]));
        if (lastNewLine + 1 == stringBuilder.length()) {
            stringBuilder.replace(lastNewLine, lastNewLine + 1, "");
        }
    }
}

