/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.IteratorArbitrary;
import net.jqwik.api.arbitraries.ListArbitrary;
import net.jqwik.api.arbitraries.SetArbitrary;
import net.jqwik.api.arbitraries.StreamArbitrary;
import net.jqwik.api.arbitraries.StreamableArbitrary;
import net.jqwik.engine.ArbitraryDelegator;
import net.jqwik.engine.SourceOfRandomness;
import net.jqwik.engine.properties.arbitraries.ArbitrariesSupport;
import net.jqwik.engine.properties.arbitraries.DefaultArrayArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultIteratorArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultListArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultSetArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultStreamArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesConfiguration;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;

public class ArbitraryFacadeImpl
extends Arbitrary.ArbitraryFacade {
    public <T> ListArbitrary<T> list(Arbitrary<T> elementArbitrary) {
        return new DefaultListArbitrary<T>(elementArbitrary, elementArbitrary.isUnique());
    }

    public <T> SetArbitrary<T> set(Arbitrary<T> elementArbitrary) {
        return new DefaultSetArbitrary<T>(elementArbitrary).ofMaxSize(ArbitrariesSupport.maxNumberOfElements(elementArbitrary, 255));
    }

    public <T> StreamArbitrary<T> stream(Arbitrary<T> elementArbitrary) {
        return new DefaultStreamArbitrary<T>(elementArbitrary, elementArbitrary.isUnique());
    }

    public <T> IteratorArbitrary<T> iterator(Arbitrary<T> elementArbitrary) {
        return new DefaultIteratorArbitrary<T>(elementArbitrary, elementArbitrary.isUnique());
    }

    public <T, A> StreamableArbitrary<T, A> array(Arbitrary<T> elementArbitrary, Class<A> arrayClass) {
        return new DefaultArrayArbitrary<T, A>(elementArbitrary, arrayClass, elementArbitrary.isUnique());
    }

    public <T> Arbitrary<T> filter(final Arbitrary<T> self, final Predicate<T> filterPredicate) {
        return new ArbitraryDelegator<T>(self){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return self.generator(genSize).filter(filterPredicate);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return self.exhaustive(maxNumberOfSamples).map(generator -> generator.filter(filterPredicate));
            }

            @Override
            public EdgeCases<T> edgeCases() {
                return EdgeCasesSupport.filter(self.edgeCases(), filterPredicate);
            }
        };
    }

    public <T, U> Arbitrary<U> map(final Arbitrary<T> self, final Function<T, U> mapper) {
        return new Arbitrary<U>(){

            public RandomGenerator<U> generator(int genSize) {
                return self.generator(genSize).map(mapper);
            }

            public boolean isUnique() {
                return self.isUnique();
            }

            public Optional<ExhaustiveGenerator<U>> exhaustive(long maxNumberOfSamples) {
                return self.exhaustive(maxNumberOfSamples).map(generator -> generator.map(mapper));
            }

            public EdgeCases<U> edgeCases() {
                return EdgeCasesSupport.map(self.edgeCases(), mapper);
            }
        };
    }

    public <T, U> Arbitrary<U> flatMap(final Arbitrary<T> self, final Function<T, Arbitrary<U>> mapper) {
        return new Arbitrary<U>(){

            public RandomGenerator<U> generator(int genSize) {
                return self.generator(genSize).flatMap(mapper, genSize);
            }

            public Optional<ExhaustiveGenerator<U>> exhaustive(long maxNumberOfSamples) {
                return self.exhaustive(maxNumberOfSamples).flatMap(generator -> ExhaustiveGenerators.flatMap(generator, mapper, maxNumberOfSamples));
            }

            public EdgeCases<U> edgeCases() {
                return EdgeCasesSupport.flatMapArbitrary(self.edgeCases(), mapper);
            }
        };
    }

    public <T> Stream<T> sampleStream(Arbitrary<T> arbitrary) {
        return arbitrary.generator(1000).stream(SourceOfRandomness.current()).map(Shrinkable::value);
    }

    public <T> Arbitrary<T> injectNull(Arbitrary<T> self, double nullProbability) {
        int frequencyNull = (int)Math.round(nullProbability * 100.0);
        int frequencyNotNull = 100 - frequencyNull;
        if (frequencyNull <= 0) {
            return self;
        }
        if (frequencyNull >= 100) {
            return Arbitraries.just(null);
        }
        Arbitrary withNull = Arbitraries.frequencyOf((Tuple.Tuple2[])new Tuple.Tuple2[]{Tuple.of((Object)frequencyNull, (Object)Arbitraries.just(null)), Tuple.of((Object)frequencyNotNull, self)});
        if (self.isUnique()) {
            return withNull.unique();
        }
        return withNull;
    }

    public <T> Arbitrary<T> ignoreException(final Arbitrary<T> self, final Class<? extends Throwable> exceptionType) {
        return new ArbitraryDelegator<T>(self){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return self.generator(genSize).ignoreException(exceptionType);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return self.exhaustive(maxNumberOfSamples).map(generator -> generator.ignoreException(exceptionType));
            }

            @Override
            public EdgeCases<T> edgeCases() {
                return EdgeCasesSupport.ignoreException(self.edgeCases(), exceptionType);
            }
        };
    }

    public <T> Arbitrary<T> dontShrink(final Arbitrary<T> self) {
        return new ArbitraryDelegator<T>(self){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return self.generator(genSize).dontShrink();
            }

            @Override
            public EdgeCases<T> edgeCases() {
                return EdgeCasesSupport.dontShrink(self.edgeCases());
            }
        };
    }

    public <T> Arbitrary<T> configureEdgeCases(final Arbitrary<T> self, final Consumer<EdgeCases.Config<T>> configurator) {
        final EdgeCasesConfiguration config = new EdgeCasesConfiguration();
        return new ArbitraryDelegator<T>(self){

            @Override
            public EdgeCases<T> edgeCases() {
                return config.configure(configurator, self.edgeCases());
            }
        };
    }
}

