/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.jqwik.api.SampleReportingFormat;
import net.jqwik.api.Tuple;
import net.jqwik.engine.support.JqwikExceptionSupport;
import org.junit.platform.commons.support.ReflectionSupport;

public class SampleReportingFormatFacadeImpl
extends SampleReportingFormat.SampleReportingFormatFacade {
    public Object reportJavaBean(Object bean) {
        LinkedHashMap report = new LinkedHashMap();
        Arrays.stream(bean.getClass().getMethods()).filter(method -> !method.getName().equals("getClass")).filter(method -> method.getName().startsWith("get") || method.getName().startsWith("is")).map(method -> Tuple.of((Object)this.extractPropertyName((Method)method), (Object)method)).sorted(Comparator.comparing(Tuple.Tuple1::get1)).forEach(tuple -> this.appendGetterToReport(report, (Tuple.Tuple2<String, Method>)tuple, bean));
        return report;
    }

    private void appendGetterToReport(Map<Object, Object> report, Tuple.Tuple2<String, Method> method, Object bean) {
        this.appendIfNotNull(report, (String)method.get1(), () -> {
            try {
                return ReflectionSupport.invokeMethod((Method)((Method)method.get2()), (Object)bean, (Object[])new Object[0]);
            }
            catch (Throwable e) {
                JqwikExceptionSupport.rethrowIfBlacklisted(e);
                return "<illegal access>";
            }
        });
    }

    private String extractPropertyName(Method method) {
        String methodName = method.getName();
        String name = methodName.startsWith("get") ? methodName.substring(3) : (methodName.startsWith("is") ? methodName.substring(2) : methodName);
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        return name;
    }

    private void appendIfNotNull(Map<Object, Object> report, String name, Supplier<Object> supplier) {
        Object value = supplier.get();
        if (value != null) {
            report.put(SampleReportingFormat.plainLabel((String)name), value);
        }
    }
}

