/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.facades.TypeUsageImpl;
import net.jqwik.engine.support.MethodParameter;

class RandomizedParameterGenerator {
    private final TypeUsage typeUsage;
    private final List<Arbitrary<Object>> arbitraries;
    private final int genSize;

    RandomizedParameterGenerator(MethodParameter parameter, Set<Arbitrary<Object>> arbitraries, int genSize) {
        this.typeUsage = TypeUsageImpl.forParameter(parameter);
        this.arbitraries = new ArrayList<Arbitrary<Object>>(arbitraries);
        this.genSize = genSize;
    }

    Shrinkable<Object> next(Random random, Map<TypeUsage, Arbitrary<Object>> arbitrariesCache) {
        RandomGenerator<Object> selectedGenerator = this.selectGenerator(random, arbitrariesCache);
        return selectedGenerator.next(random);
    }

    private RandomGenerator<Object> selectGenerator(Random random, Map<TypeUsage, Arbitrary<Object>> arbitrariesCache) {
        if (arbitrariesCache.containsKey(this.typeUsage)) {
            return arbitrariesCache.get(this.typeUsage).generator(this.genSize);
        }
        int index = this.arbitraries.size() == 1 ? 0 : random.nextInt(this.arbitraries.size());
        Arbitrary<Object> selectedArbitrary = this.arbitraries.get(index);
        arbitrariesCache.put(this.typeUsage, selectedArbitrary);
        return selectedArbitrary.generator(this.genSize);
    }
}

