/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;

public class CharacterRangeArbitrary
implements Arbitrary<Character> {
    private final char min;
    private final char max;

    public CharacterRangeArbitrary(char min, char max) {
        this.min = min;
        this.max = max;
    }

    public RandomGenerator<Character> generator(int genSize) {
        return RandomGenerators.chars(this.min, this.max).withEdgeCases(genSize, this.edgeCases());
    }

    private List<Shrinkable<Character>> listOfEdgeCases() {
        return Stream.of(Character.valueOf(this.min), Character.valueOf(this.max)).map(aCharacter -> new ShrinkableBigInteger(BigInteger.valueOf(aCharacter.charValue()), Range.of(BigInteger.valueOf(this.min), BigInteger.valueOf(this.max)), BigInteger.valueOf(this.min))).map(shrinkableBigInteger -> shrinkableBigInteger.map(BigInteger::intValueExact)).map(shrinkableInteger -> shrinkableInteger.map(anInt -> Character.valueOf((char)anInt.intValue()))).collect(Collectors.toList());
    }

    public Optional<ExhaustiveGenerator<Character>> exhaustive(long maxNumberOfSamples) {
        long maxCount = this.max + '\u0001' - this.min;
        return ExhaustiveGenerators.fromIterable(() -> IntStream.range(this.min, this.max + '\u0001').iterator(), maxCount, maxNumberOfSamples).map(optionalGenerator -> optionalGenerator.map(anInt -> Character.valueOf((char)anInt.intValue())));
    }

    public EdgeCases<Character> edgeCases() {
        return EdgeCasesSupport.fromShrinkables(this.listOfEdgeCases());
    }
}

