/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.configurators.SelfConfiguringArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.MultivalueArbitraryBase;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableList;

public class DefaultArrayArbitrary<T, A>
extends MultivalueArbitraryBase<T, A>
implements SelfConfiguringArbitrary<A> {
    private final Class<A> arrayClass;

    public DefaultArrayArbitrary(Arbitrary<T> elementArbitrary, Class<A> arrayClass, boolean elementsUnique) {
        super(elementArbitrary, elementsUnique);
        this.arrayClass = arrayClass;
    }

    public RandomGenerator<A> generator(int genSize) {
        return this.createListGenerator(genSize).map(this::toArray);
    }

    public Optional<ExhaustiveGenerator<A>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.list(this.elementArbitrary, this.minSize, this.maxSize, maxNumberOfSamples).map(generator -> generator.map(this::toArray));
    }

    public EdgeCases<A> edgeCases() {
        return EdgeCasesSupport.map(this.edgeCases((elements, minSize1) -> new ShrinkableList(elements, (int)minSize1, this.maxSize)), this::toArray);
    }

    private A toArray(List<T> from) {
        Object array = Array.newInstance(this.arrayClass.getComponentType(), from.size());
        for (int i = 0; i < from.size(); ++i) {
            Array.set(array, i, from.get(i));
        }
        return (A)array;
    }

    @Override
    protected Iterable<T> toIterable(A array) {
        return () -> Arrays.stream((Object[])array).iterator();
    }

    public Arbitrary<A> configure(ArbitraryConfigurator configurator, TypeUsage targetType) {
        targetType.getComponentType().ifPresent(elementType -> {
            this.elementArbitrary = configurator.configure(this.elementArbitrary, elementType);
        });
        return configurator.configure((Arbitrary)this, targetType);
    }
}

