/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.SetArbitrary;
import net.jqwik.engine.properties.arbitraries.MultivalueArbitraryBase;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableSet;

public class DefaultSetArbitrary<T>
extends MultivalueArbitraryBase<T, Set<T>>
implements SetArbitrary<T> {
    public DefaultSetArbitrary(Arbitrary<T> elementArbitrary) {
        super(elementArbitrary, true);
    }

    @Override
    protected Iterable<T> toIterable(Set<T> streamable) {
        return streamable;
    }

    public RandomGenerator<Set<T>> generator(int genSize) {
        int cutoffSize = this.cutoffSize(genSize);
        RandomGenerator elementGenerator = this.elementGenerator(this.elementArbitrary, genSize);
        return RandomGenerators.set(elementGenerator, this.minSize, this.maxSize, cutoffSize).withEdgeCases(genSize, this.edgeCases());
    }

    public Optional<ExhaustiveGenerator<Set<T>>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.set(this.elementArbitrary, this.minSize, this.maxSize, maxNumberOfSamples);
    }

    public EdgeCases<Set<T>> edgeCases() {
        return this.edgeCases((elementList, minSize1) -> {
            HashSet elementSet = new HashSet(elementList);
            return new ShrinkableSet(elementSet, (int)minSize1, this.maxSize);
        });
    }

    public SetArbitrary<T> ofMaxSize(int maxSize) {
        return (SetArbitrary)super.ofMaxSize(maxSize);
    }

    public SetArbitrary<T> ofMinSize(int minSize) {
        return (SetArbitrary)super.ofMinSize(minSize);
    }

    public <U> Arbitrary<Set<U>> mapEach(BiFunction<Set<T>, T, U> mapper) {
        return this.map(elements -> elements.stream().map(e -> mapper.apply((Set)elements, (Object)e)).collect(Collectors.toSet()));
    }

    public <U> Arbitrary<Set<U>> flatMapEach(BiFunction<Set<T>, T, Arbitrary<U>> flatMapper) {
        return this.flatMap(elements -> {
            List arbitraries = elements.stream().map(e -> (Arbitrary)flatMapper.apply((Set)elements, (Object)e)).collect(Collectors.toList());
            return Combinators.combine(arbitraries).as(HashSet::new);
        });
    }
}

