/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;

public class EdgeCasesConfiguration<T>
implements EdgeCases.Config<T> {
    private boolean none;
    private final List<Predicate<T>> filters = new ArrayList<Predicate<T>>();
    private final List<T> additionalEdgeCases = new ArrayList<T>();

    public EdgeCases.Config<T> none() {
        this.none = true;
        return this;
    }

    public EdgeCases.Config<T> filter(Predicate<T> filter) {
        this.filters.add(filter);
        return this;
    }

    public EdgeCases.Config<T> add(T edgeCase) {
        this.additionalEdgeCases.add(edgeCase);
        return this;
    }

    @SafeVarargs
    public final EdgeCases.Config<T> includeOnly(T ... includedValues) {
        List<T> values = Arrays.asList(includedValues);
        return this.filter(values::contains);
    }

    public EdgeCases<T> configure(Consumer<EdgeCases.Config<T>> configurator, EdgeCases<T> defaultEdgeCases) {
        configurator.accept(this);
        EdgeCases<T> configuredEdgeCases = defaultEdgeCases;
        if (this.none) {
            configuredEdgeCases = EdgeCases.none();
        }
        for (Predicate<T> filter : this.filters) {
            configuredEdgeCases = EdgeCasesSupport.filter(configuredEdgeCases, filter);
        }
        ArrayList suppliers = new ArrayList(configuredEdgeCases.suppliers());
        for (Object additionalEdgeCase : this.additionalEdgeCases) {
            suppliers.add(() -> Shrinkable.unshrinkable((Object)additionalEdgeCase));
        }
        return EdgeCasesSupport.fromSuppliers(suppliers);
    }
}

