/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.engine.SourceOfRandomness;
import net.jqwik.engine.facades.EdgeCasesFacadeImpl;
import net.jqwik.engine.properties.shrinking.ChooseValueShrinkable;
import net.jqwik.engine.properties.shrinking.FilteredShrinkable;
import net.jqwik.engine.properties.shrinking.FixedValueFlatMappedShrinkable;
import net.jqwik.engine.support.JqwikStringSupport;

public class EdgeCasesSupport {
    private static final int MAX_NUMBER_OF_EDGE_CASES = 1000;
    private static final Logger LOG = Logger.getLogger(EdgeCasesSupport.class.getName());
    private static final Store<Boolean> warningAlreadyLogged = EdgeCasesSupport.initWarningAlreadyLogged();

    public static <T> EdgeCases<T> fromSuppliers(final List<Supplier<Shrinkable<T>>> suppliers) {
        return new EdgeCases<T>(){

            public List<Supplier<Shrinkable<T>>> suppliers() {
                return suppliers;
            }

            public String toString() {
                String edgeCases = suppliers.stream().map(Supplier::get).map(Shrinkable::value).map(JqwikStringSupport::displayString).collect(Collectors.joining(", "));
                return String.format("EdgeCases[%s]", edgeCases);
            }
        };
    }

    public static <T> EdgeCases<T> choose(List<T> values) {
        ArrayList<Shrinkable<T>> shrinkables = new ArrayList<Shrinkable<T>>();
        if (values.size() > 0) {
            shrinkables.add(new ChooseValueShrinkable<T>(values.get(0), values));
        }
        if (values.size() > 1) {
            int lastIndex = values.size() - 1;
            shrinkables.add(new ChooseValueShrinkable<T>(values.get(lastIndex), values));
        }
        try {
            if (values.contains(null)) {
                shrinkables.add(Shrinkable.unshrinkable(null));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return EdgeCasesSupport.fromShrinkables(shrinkables);
    }

    public static <T> EdgeCases<T> concatFrom(List<Arbitrary<T>> arbitraries) {
        ArrayList<Shrinkable<T>> shrinkables = new ArrayList<Shrinkable<T>>();
        for (Arbitrary<T> arbitrary : arbitraries) {
            shrinkables.add(new ChooseValueShrinkable<Arbitrary<T>>(arbitrary, arbitraries));
        }
        return EdgeCasesSupport.flatMapArbitrary(EdgeCasesSupport.fromShrinkables(shrinkables), Function.identity());
    }

    public static <T> EdgeCases<T> concat(List<EdgeCases<T>> edgeCases) {
        if (edgeCases.isEmpty()) {
            return EdgeCases.none();
        }
        if (edgeCases.size() == 1) {
            return edgeCases.get(0);
        }
        ArrayList<Supplier<Shrinkable<T>>> concatenatedSuppliers = new ArrayList<Supplier<Shrinkable<T>>>();
        for (EdgeCases<T> edgeCase : edgeCases) {
            if (edgeCase.isEmpty()) continue;
            concatenatedSuppliers.addAll(edgeCase.suppliers());
        }
        return EdgeCasesSupport.fromSuppliers(concatenatedSuppliers);
    }

    @SafeVarargs
    static <T> EdgeCases<T> concat(EdgeCases<T> ... rest) {
        return EdgeCasesSupport.concat(Arrays.asList(rest));
    }

    public static <T> EdgeCases<T> fromShrinkables(List<Shrinkable<T>> shrinkables) {
        return () -> shrinkables.stream().map(shrinkable -> () -> shrinkable).collect(Collectors.toList());
    }

    public static <T, U> EdgeCases<U> map(EdgeCases<T> self, Function<T, U> mapper) {
        return EdgeCasesSupport.mapShrinkable(self, tShrinkable -> tShrinkable.map(mapper));
    }

    public static <T, U> EdgeCases<U> mapShrinkable(EdgeCases<T> self, Function<Shrinkable<T>, Shrinkable<U>> mapper) {
        List mappedSuppliers = self.suppliers().stream().map(tSupplier -> () -> EdgeCasesSupport.lambda$mapShrinkable$4(mapper, (Supplier)tSupplier)).collect(Collectors.toList());
        return EdgeCases.fromSuppliers(mappedSuppliers);
    }

    public static <T> EdgeCases<T> filter(EdgeCases<T> self, Predicate<T> filterPredicate) {
        List filteredSuppliers = self.suppliers().stream().filter(supplier -> filterPredicate.test(((Shrinkable)supplier.get()).value())).map(supplier -> () -> EdgeCasesSupport.lambda$filter$7((Supplier)supplier, filterPredicate)).collect(Collectors.toList());
        return EdgeCases.fromSuppliers(filteredSuppliers);
    }

    public static <T> EdgeCases<T> ignoreException(EdgeCases<T> self, Class<? extends Throwable> exceptionType) {
        List filteredSuppliers = self.suppliers().stream().filter(supplier -> {
            try {
                ((Shrinkable)supplier.get()).value();
                return true;
            }
            catch (Throwable throwable) {
                if (exceptionType.isAssignableFrom(throwable.getClass())) {
                    return false;
                }
                throw throwable;
            }
        }).collect(Collectors.toList());
        return EdgeCases.fromSuppliers(filteredSuppliers);
    }

    public static <T> EdgeCases<T> dontShrink(EdgeCases<T> self) {
        return () -> self.suppliers().stream().map(supplier -> () -> EdgeCasesSupport.lambda$dontShrink$10((Supplier)supplier)).collect(Collectors.toList());
    }

    public static <T, U> EdgeCases<U> flatMapArbitrary(EdgeCases<T> self, Function<T, Arbitrary<U>> mapper) {
        List flatMappedSuppliers = self.suppliers().stream().flatMap(tSupplier -> {
            Object t = ((Shrinkable)tSupplier.get()).value();
            return ((Arbitrary)mapper.apply(t)).edgeCases().suppliers().stream().map(arg_0 -> EdgeCasesSupport.lambda$flatMapArbitrary$15(mapper, (Supplier)tSupplier, arg_0));
        }).limit(1000L).collect(Collectors.toList());
        if (flatMappedSuppliers.size() >= 1000) {
            EdgeCasesSupport.logTooManyEdgeCases(1000);
        }
        return EdgeCases.fromSuppliers(flatMappedSuppliers);
    }

    private static Store<Boolean> initWarningAlreadyLogged() {
        try {
            return Store.create((Object)Tuple.of(EdgeCasesFacadeImpl.class, (Object)"warning"), (Lifespan)Lifespan.PROPERTY, () -> false);
        }
        catch (JqwikException jqwikException) {
            return new Store<Boolean>(){

                public Boolean get() {
                    return true;
                }

                public Lifespan lifespan() {
                    return Lifespan.PROPERTY;
                }

                public void update(Function<Boolean, Boolean> updater) {
                }

                public void reset() {
                }

                public Store<Boolean> onClose(Consumer<Boolean> onCloseCallback) {
                    return this;
                }
            };
        }
    }

    private static void logTooManyEdgeCases(int maxNumberOfEdgeCases) {
        if (((Boolean)warningAlreadyLogged.get()).booleanValue()) {
            return;
        }
        String message = String.format("Combinatorial explosion of edge case generation. Stopped creating more after %s generated cases.", maxNumberOfEdgeCases);
        LOG.warning(message);
        warningAlreadyLogged.update(ignore -> true);
    }

    private static /* synthetic */ Supplier lambda$flatMapArbitrary$15(Function mapper, Supplier tSupplier, Supplier uSupplier) {
        Function<Object, Shrinkable> shrinkableMapper = newT -> ((Arbitrary)mapper.apply(newT)).generator(1000).next(SourceOfRandomness.newRandom(42L));
        return () -> EdgeCasesSupport.lambda$flatMapArbitrary$14((Supplier)tSupplier, shrinkableMapper, (Supplier)uSupplier);
    }

    private static /* synthetic */ Shrinkable lambda$flatMapArbitrary$14(Supplier tSupplier, Function shrinkableMapper, Supplier uSupplier) {
        return new FixedValueFlatMappedShrinkable((Shrinkable)tSupplier.get(), shrinkableMapper, uSupplier);
    }

    private static /* synthetic */ Shrinkable lambda$dontShrink$10(Supplier supplier) {
        return ((Shrinkable)supplier.get()).makeUnshrinkable();
    }

    private static /* synthetic */ Shrinkable lambda$filter$7(Supplier supplier, Predicate filterPredicate) {
        return new FilteredShrinkable((Shrinkable)supplier.get(), filterPredicate);
    }

    private static /* synthetic */ Shrinkable lambda$mapShrinkable$4(Function mapper, Supplier tSupplier) {
        return (Shrinkable)mapper.apply((Shrinkable)tSupplier.get());
    }
}

