/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomIntegralGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;

class IntegralGeneratingArbitrary
implements Arbitrary<BigInteger> {
    BigInteger min;
    BigInteger max;
    BigInteger shrinkingTarget;
    RandomDistribution distribution = RandomDistribution.biased();

    IntegralGeneratingArbitrary(BigInteger defaultMin, BigInteger defaultMax) {
        this.min = defaultMin;
        this.max = defaultMax;
        this.shrinkingTarget = null;
    }

    public RandomGenerator<BigInteger> generator(int genSize) {
        return RandomGenerators.bigIntegers(this.min, this.max, this.shrinkingTarget(), this.distribution).withEdgeCases(genSize, this.edgeCases());
    }

    public Optional<ExhaustiveGenerator<BigInteger>> exhaustive(long maxNumberOfSamples) {
        BigInteger maxCount = this.max.subtract(this.min).add(BigInteger.ONE);
        if (maxCount.compareTo(BigInteger.valueOf(maxNumberOfSamples)) > 0) {
            return Optional.empty();
        }
        return ExhaustiveGenerators.fromIterable(() -> new RangeIterator(), maxCount.longValueExact(), maxNumberOfSamples);
    }

    public EdgeCases<BigInteger> edgeCases() {
        List shrinkables = this.streamEdgeCases().map(value -> new ShrinkableBigInteger((BigInteger)value, Range.of(this.min, this.max), this.shrinkingTarget())).collect(Collectors.toList());
        return EdgeCasesSupport.fromShrinkables(shrinkables);
    }

    private Stream<BigInteger> streamEdgeCases() {
        return this.streamRawEdgeCases().distinct().filter(aBigInt -> aBigInt.compareTo(this.min) >= 0 && aBigInt.compareTo(this.max) <= 0);
    }

    private Stream<BigInteger> streamRawEdgeCases() {
        BigInteger[] literalEdgeCases = new BigInteger[]{BigInteger.valueOf(-2L), BigInteger.valueOf(-1L), BigInteger.ZERO, BigInteger.valueOf(2L), BigInteger.valueOf(1L), this.min, this.min.add(BigInteger.ONE), this.max, this.max.subtract(BigInteger.ONE)};
        return this.shrinkingTarget == null ? Arrays.stream(literalEdgeCases) : Stream.concat(Stream.of(this.shrinkingTarget), Arrays.stream(literalEdgeCases));
    }

    private BigInteger shrinkingTarget() {
        if (this.shrinkingTarget == null) {
            return RandomIntegralGenerators.defaultShrinkingTarget(Range.of(this.min, this.max));
        }
        return this.shrinkingTarget;
    }

    class RangeIterator
    implements Iterator<BigInteger> {
        BigInteger current;

        RangeIterator() {
            this.current = IntegralGeneratingArbitrary.this.min;
        }

        @Override
        public boolean hasNext() {
            return this.current.compareTo(IntegralGeneratingArbitrary.this.max) <= 0;
        }

        @Override
        public BigInteger next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BigInteger next = this.current;
            this.current = this.current.add(BigInteger.ONE);
            return next;
        }
    }
}

