/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.shrinking.ChooseValueShrinkable;
import net.jqwik.engine.support.JqwikStringSupport;

public class FrequencyGenerator<T>
implements RandomGenerator<T> {
    private final Map<T, Integer> upperBorders = new HashMap<T, Integer>();
    private int size = 0;
    private List<T> valuesToChooseFrom;

    FrequencyGenerator(List<Tuple.Tuple2<Integer, T>> frequencies) {
        this.calculateUpperBorders(frequencies);
        if (this.size <= 0) {
            throw new JqwikException(String.format("%s does not contain any positive frequencies.", JqwikStringSupport.displayString(frequencies)));
        }
    }

    private void calculateUpperBorders(List<Tuple.Tuple2<Integer, T>> frequencies) {
        ArrayList<T> values = new ArrayList<T>();
        for (Tuple.Tuple2<Integer, T> tuple : frequencies) {
            int frequency = (Integer)tuple.get1();
            if (frequency <= 0) continue;
            this.size += frequency;
            Object value = tuple.get2();
            values.add(value);
            this.upperBorders.put(value, this.size);
        }
        this.valuesToChooseFrom = values;
    }

    private T choose(int index) {
        T currentChoice = null;
        for (T key : this.upperBorders.keySet()) {
            int upper = this.upperBorders.get(key);
            if (upper <= index) continue;
            if (currentChoice == null) {
                currentChoice = key;
                continue;
            }
            if (upper >= this.upperBorders.get(currentChoice)) continue;
            currentChoice = key;
        }
        return currentChoice;
    }

    public Shrinkable<T> next(Random random) {
        int index = random.nextInt(this.size);
        return new ChooseValueShrinkable<T>(this.choose(index), this.valuesToChooseFrom);
    }
}

