/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.MaxTriesLoop;
import net.jqwik.engine.properties.shrinking.UniqueShrinkable;

public class UniqueGenerator<T>
implements RandomGenerator<T> {
    private final RandomGenerator<T> toFilter;
    private final Set<T> usedValues = Collections.synchronizedSet(new HashSet());

    public UniqueGenerator(RandomGenerator<T> toFilter) {
        this.toFilter = toFilter;
    }

    public Shrinkable<T> next(Random random) {
        return this.nextUntilAccepted(random, r -> {
            Shrinkable next = this.toFilter.next(r);
            return new UniqueShrinkable(next, this::shrink);
        });
    }

    public String toString() {
        return String.format("Unique [%s]", this.toFilter);
    }

    private Shrinkable<T> nextUntilAccepted(Random random, Function<Random, Shrinkable<T>> fetchShrinkable) {
        return MaxTriesLoop.loop(() -> true, next -> {
            next = (Shrinkable)fetchShrinkable.apply(random);
            Object value = next.value();
            if (this.usedValues.contains(value)) {
                return Tuple.of((Object)false, (Object)next);
            }
            this.usedValues.add(value);
            return Tuple.of((Object)true, (Object)next);
        }, maxMisses -> {
            String message = String.format("%s missed more than %s times.", this.toString(), maxMisses);
            return new TooManyFilterMissesException(message);
        });
    }

    private Stream<Shrinkable<T>> shrink(UniqueShrinkable<T> current) {
        return current.toFilter.shrink().filter(s -> !this.usedValues.contains(s.value())).map(s -> {
            this.usedValues.add(s.value());
            return new UniqueShrinkable(s, this::shrink);
        });
    }
}

