/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import net.jqwik.api.Falsifier;
import net.jqwik.api.ShrinkingMode;
import net.jqwik.api.lifecycle.FalsifiedSample;
import net.jqwik.api.lifecycle.ShrunkFalsifiedSample;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.engine.properties.ShrunkFalsifiedSampleImpl;
import net.jqwik.engine.properties.shrinking.ErrorEquivalenceChecker;
import net.jqwik.engine.properties.shrinking.OneAfterTheOtherParameterShrinker;
import net.jqwik.engine.properties.shrinking.PairwiseParameterShrinker;
import net.jqwik.engine.support.JqwikExceptionSupport;

public class PropertyShrinker {
    private static final Logger LOG = Logger.getLogger(PropertyShrinker.class.getName());
    private final FalsifiedSample originalSample;
    private final ShrinkingMode shrinkingMode;
    private final int boundedShrinkingSeconds;
    private final Consumer<FalsifiedSample> falsifiedSampleReporter;
    private final Method targetMethod;
    private final AtomicInteger shrinkingStepsCounter = new AtomicInteger(0);
    private final Map<List<Object>, TryExecutionResult> falsificationCache = new HashMap<List<Object>, TryExecutionResult>();
    private Optional<FalsifiedSample> currentBest = Optional.empty();

    public PropertyShrinker(FalsifiedSample originalSample, ShrinkingMode shrinkingMode, int boundedShrinkingSeconds, Consumer<FalsifiedSample> falsifiedSampleReporter, Method targetMethod) {
        this.originalSample = originalSample;
        this.shrinkingMode = shrinkingMode;
        this.boundedShrinkingSeconds = boundedShrinkingSeconds;
        this.falsifiedSampleReporter = falsifiedSampleReporter;
        this.targetMethod = targetMethod;
    }

    public ShrunkFalsifiedSample shrink(Falsifier<List<Object>> forAllFalsifier) {
        if (this.shrinkingMode == ShrinkingMode.OFF) {
            return this.unshrunkOriginalSample();
        }
        Falsifier allowOnlyEquivalentErrorsFalsifier = sample -> {
            TryExecutionResult result = forAllFalsifier.execute(sample);
            if (this.isFalsifiedButErrorIsNotEquivalent(result, this.originalSample.falsifyingError())) {
                return TryExecutionResult.invalid();
            }
            return result;
        };
        Consumer<FalsifiedSample> shrinkSampleConsumer = sample -> {
            this.shrinkingStepsCounter.incrementAndGet();
            this.falsifiedSampleReporter.accept((FalsifiedSample)sample);
        };
        Consumer<FalsifiedSample> shrinkAttemptConsumer = currentBest -> {
            if (currentBest != null) {
                this.currentBest = Optional.of(currentBest);
            }
        };
        return this.shrink((Falsifier<List<Object>>)allowOnlyEquivalentErrorsFalsifier, shrinkSampleConsumer, shrinkAttemptConsumer);
    }

    public ShrunkFalsifiedSample shrink(Falsifier<List<Object>> falsifier, Consumer<FalsifiedSample> shrinkSampleConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        Supplier<FalsifiedSample> shrinkUntilDone = () -> this.shrinkAsLongAsSampleImproves(falsifier, shrinkSampleConsumer, shrinkAttemptConsumer);
        FalsifiedSample fullyShrunkSample = this.shrinkingMode == ShrinkingMode.FULL ? shrinkUntilDone.get() : this.withTimeout(shrinkUntilDone);
        return new ShrunkFalsifiedSampleImpl(fullyShrunkSample, this.shrinkingStepsCounter.get());
    }

    private FalsifiedSample withTimeout(Supplier<FalsifiedSample> shrinkUntilDone) {
        try {
            CompletableFuture<FalsifiedSample> falsifiedSampleFuture = CompletableFuture.supplyAsync(shrinkUntilDone);
            return falsifiedSampleFuture.get(this.boundedShrinkingSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            return (FalsifiedSample)JqwikExceptionSupport.throwAsUncheckedException(e);
        }
        catch (TimeoutException e) {
            this.logShrinkingBoundReached();
            return this.currentBest.orElse(this.originalSample);
        }
    }

    public FalsifiedSample shrinkAsLongAsSampleImproves(Falsifier<List<Object>> falsifier, Consumer<FalsifiedSample> shrinkSampleConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        FalsifiedSample before;
        FalsifiedSample after = this.originalSample;
        do {
            before = after;
            after = this.shrinkOneParameterAfterTheOther(falsifier, before, shrinkSampleConsumer, shrinkAttemptConsumer);
        } while (!(after = this.shrinkParametersPairwise(falsifier, after, shrinkSampleConsumer, shrinkAttemptConsumer)).equals(before));
        return after;
    }

    private FalsifiedSample shrinkOneParameterAfterTheOther(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> shrinkSampleConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        return new OneAfterTheOtherParameterShrinker(this.falsificationCache).shrink(falsifier, sample, shrinkSampleConsumer, shrinkAttemptConsumer);
    }

    private FalsifiedSample shrinkParametersPairwise(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> shrinkSampleConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        return new PairwiseParameterShrinker(this.falsificationCache).shrink(falsifier, sample, shrinkSampleConsumer, shrinkAttemptConsumer);
    }

    private ShrunkFalsifiedSample unshrunkOriginalSample() {
        return new ShrunkFalsifiedSampleImpl(this.originalSample, 0);
    }

    private boolean isFalsifiedButErrorIsNotEquivalent(TryExecutionResult result, Optional<Throwable> originalError) {
        boolean areEquivalent = new ErrorEquivalenceChecker(this.targetMethod).areEquivalent(originalError, result.throwable());
        return result.isFalsified() && !areEquivalent;
    }

    private void logShrinkingBoundReached() {
        String value = String.format("Shrinking timeout reached after %s seconds.%n  You can switch on full shrinking with '@Property(shrinking = ShrinkingMode.FULL)'", this.boundedShrinkingSeconds);
        LOG.warning(value);
    }
}

