/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.shrinking.ShrinkableContainer;
import net.jqwik.engine.support.Combinatorics;
import net.jqwik.engine.support.JqwikStreamSupport;

public class ShrinkableList<E>
extends ShrinkableContainer<List<E>, E> {
    public ShrinkableList(List<Shrinkable<E>> elements, int minSize, int maxSize) {
        super(elements, minSize, maxSize);
    }

    @Override
    Collector<E, ?, List<E>> containerCollector() {
        return Collectors.toList();
    }

    @Override
    Shrinkable<List<E>> createShrinkable(List<Shrinkable<E>> shrunkElements) {
        return new ShrinkableList<E>(shrunkElements, this.minSize, this.maxSize);
    }

    @Override
    public Stream<Shrinkable<List<E>>> shrink() {
        return JqwikStreamSupport.concat(super.shrink(), this.sortElements(), this.moveIndividualValuesTowardsEnd());
    }

    private Stream<Shrinkable<List<E>>> moveIndividualValuesTowardsEnd() {
        ShrinkingDistance distance = this.distance();
        return Combinatorics.distinctPairs(this.elements.size()).map(pair -> {
            int firstIndex = Math.min((Integer)pair.get1(), (Integer)pair.get2());
            int secondIndex = Math.max((Integer)pair.get1(), (Integer)pair.get2());
            Shrinkable first = (Shrinkable)this.elements.get(firstIndex);
            Shrinkable second = (Shrinkable)this.elements.get(secondIndex);
            return Tuple.of((Object)firstIndex, (Object)first, (Object)secondIndex, (Object)second);
        }).filter(quadruple -> ((Shrinkable)quadruple.get2()).compareTo((Shrinkable)quadruple.get4()) <= 0).flatMap(quadruple -> {
            int firstIndex = (Integer)quadruple.get1();
            Shrinkable first = (Shrinkable)quadruple.get2();
            int secondIndex = (Integer)quadruple.get3();
            Shrinkable second = (Shrinkable)quadruple.get4();
            return first.shrink().map(after -> {
                Optional grow = second.grow(first, after);
                return Tuple.of((Object)after, (Object)grow);
            }).filter(tuple -> ((Optional)tuple.get2()).isPresent()).map(tuple -> {
                ArrayList<Shrinkable<Shrinkable>> pairMove = new ArrayList<Shrinkable<Shrinkable>>(this.elements);
                pairMove.set(firstIndex, (Shrinkable)tuple.get1());
                pairMove.set(secondIndex, (Shrinkable)((Optional)tuple.get2()).get());
                return this.createShrinkable(pairMove);
            });
        }).filter(s -> s.distance().compareTo(distance) <= 0);
    }
}

