/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.engine.support.Combinatorics;
import net.jqwik.engine.support.JqwikStreamSupport;

class ShrinkingSupport {
    ShrinkingSupport() {
    }

    static <C, E> Stream<Shrinkable<C>> sortElements(List<Shrinkable<E>> elements, ContainerCreator<C, E> createContainer) {
        ArrayList<Shrinkable<Shrinkable>> sortedElements = new ArrayList<Shrinkable<Shrinkable>>(elements);
        sortedElements.sort(Comparator.comparing(Shrinkable::distance));
        if (elements.equals(sortedElements)) {
            return Stream.empty();
        }
        return JqwikStreamSupport.concat(ShrinkingSupport.fullSort(sortedElements, createContainer), ShrinkingSupport.pairwiseSort(elements, createContainer));
    }

    private static <C, E> Stream<Shrinkable<C>> fullSort(List<Shrinkable<E>> sortedElements, ContainerCreator<C, E> createContainer) {
        return Stream.of((Shrinkable)createContainer.apply(sortedElements));
    }

    private static <C, E> Stream<Shrinkable<C>> pairwiseSort(List<Shrinkable<E>> elements, ContainerCreator<C, E> createContainer) {
        return Combinatorics.distinctPairs(elements.size()).map(pair -> {
            int firstIndex = Math.min((Integer)pair.get1(), (Integer)pair.get2());
            int secondIndex = Math.max((Integer)pair.get1(), (Integer)pair.get2());
            Shrinkable first = (Shrinkable)elements.get(firstIndex);
            Shrinkable second = (Shrinkable)elements.get(secondIndex);
            return Tuple.of((Object)firstIndex, (Object)first, (Object)secondIndex, (Object)second);
        }).filter(quadruple -> ((Shrinkable)quadruple.get2()).compareTo((Shrinkable)quadruple.get4()) > 0).map(quadruple -> {
            ArrayList<Shrinkable> pairSwap = new ArrayList<Shrinkable>(elements);
            pairSwap.set((Integer)quadruple.get1(), (Shrinkable)quadruple.get4());
            pairSwap.set((Integer)quadruple.get3(), (Shrinkable)quadruple.get2());
            return (Shrinkable)createContainer.apply(pairSwap);
        });
    }

    @FunctionalInterface
    static interface ContainerCreator<C, E>
    extends Function<List<Shrinkable<E>>, Shrinkable<C>> {
    }
}

