/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.jqwik.engine.support.JqwikStreamSupport;

public class SizeOfListShrinker<T> {
    private final int minSize;

    public SizeOfListShrinker(int minSize) {
        this.minSize = minSize;
    }

    public Stream<List<T>> shrink(List<T> toShrink) {
        if (toShrink.size() <= this.minSize) {
            return Stream.empty();
        }
        return JqwikStreamSupport.concat(this.emptyList(), this.cuts(toShrink)).filter(l -> l.size() >= this.minSize);
    }

    private Stream<List<T>> emptyList() {
        return Stream.of(new ArrayList());
    }

    public Stream<List<T>> cuts(List<T> toShrink) {
        HashSet<List<T>> lists = new HashSet<List<T>>();
        this.appendRightCuts(toShrink, lists);
        this.appendLeftCuts(toShrink, lists);
        return lists.stream();
    }

    private void appendLeftCuts(List<T> toShrink, Set<List<T>> lists) {
        int elementsToCut = this.calculateElementsToCut(toShrink.size());
        this.appendLeftCut(toShrink, lists, elementsToCut);
        if (elementsToCut != 1) {
            this.appendLeftCut(toShrink, lists, 1);
        }
    }

    private void appendLeftCut(List<T> toShrink, Set<List<T>> lists, int elementsToCut) {
        ArrayList<T> leftCut = new ArrayList<T>(toShrink);
        this.cutFromLeft(leftCut, elementsToCut);
        lists.add(leftCut);
    }

    private int calculateElementsToCut(int listSize) {
        int toCut = this.rawElementsToCut(listSize);
        return Math.min(toCut, listSize - this.minSize);
    }

    private int rawElementsToCut(int listSize) {
        if (listSize <= 10) {
            return 1;
        }
        if (listSize < 20) {
            return listSize - 9;
        }
        return listSize / 2;
    }

    private void cutFromLeft(List<T> leftCut, int elementsToCut) {
        if (elementsToCut == 0) {
            return;
        }
        leftCut.remove(0);
        this.cutFromLeft(leftCut, --elementsToCut);
    }

    private void appendRightCuts(List<T> toShrink, Set<List<T>> lists) {
        int elementsToCut = this.calculateElementsToCut(toShrink.size());
        this.appendRightCut(toShrink, lists, elementsToCut);
        if (elementsToCut != 1) {
            this.appendRightCut(toShrink, lists, 1);
        }
    }

    private void appendRightCut(List<T> toShrink, Set<List<T>> lists, int elementsToCut) {
        ArrayList<T> rightCut = new ArrayList<T>(toShrink);
        this.cutFromRight(rightCut, elementsToCut);
        lists.add(rightCut);
    }

    private void cutFromRight(List<T> rightCut, int elementsToCut) {
        if (elementsToCut == 0) {
            return;
        }
        rightCut.remove(rightCut.size() - 1);
        this.cutFromRight(rightCut, --elementsToCut);
    }
}

