/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.engine.JqwikConfiguration;
import net.jqwik.engine.JqwikProperties;
import net.jqwik.engine.PropertyAttributesDefaults;
import net.jqwik.engine.TestEngineConfiguration;
import net.jqwik.engine.recording.TestRun;
import net.jqwik.engine.recording.TestRunData;
import net.jqwik.engine.recording.TestRunDatabase;
import net.jqwik.engine.recording.TestRunRecorder;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.UniqueId;

public class DefaultJqwikConfiguration
implements JqwikConfiguration {
    private static final Logger LOG = Logger.getLogger(JqwikConfiguration.class.getName());
    private final JqwikProperties properties;
    private TestEngineConfiguration testEngineConfiguration = null;

    DefaultJqwikConfiguration(ConfigurationParameters configurationParameters) {
        this(JqwikProperties.loadWithBackwardsCompatibility(configurationParameters));
    }

    private DefaultJqwikConfiguration(JqwikProperties properties) {
        this.properties = properties;
    }

    @Override
    public PropertyAttributesDefaults propertyDefaultValues() {
        return PropertyAttributesDefaults.with(this.properties.defaultTries(), this.properties.defaultMaxDiscardRatio(), this.properties.defaultAfterFailure(), this.properties.defaultGeneration(), this.properties.defaultEdgeCases(), this.properties.defaultShrinking(), this.properties.boundedShrinkingSeconds(), this.properties.fixedSeedMode());
    }

    @Override
    public TestEngineConfiguration testEngineConfiguration() {
        if (null == this.testEngineConfiguration) {
            this.testEngineConfiguration = this.createTestEngineConfiguration();
        }
        return this.testEngineConfiguration;
    }

    @Override
    public boolean useJunitPlatformReporter() {
        return this.properties.useJunitPlatformReporter();
    }

    @Override
    public boolean reportOnlyFailures() {
        return this.properties.reportOnlyFailures();
    }

    private TestEngineConfiguration createTestEngineConfiguration() {
        String databasePath = this.properties.databasePath();
        if (databasePath == null || databasePath.trim().isEmpty()) {
            LOG.log(Level.INFO, "jqwik's test run database has been switched off");
            return this.testEngineConfigurationWithDisabledDatabase();
        }
        return this.testEngineConfigurationFromDatabase(databasePath);
    }

    private TestEngineConfiguration testEngineConfigurationWithDisabledDatabase() {
        return new TestEngineConfiguration(){

            @Override
            public TestRunRecorder recorder() {
                return TestRunRecorder.NULL;
            }

            @Override
            public TestRunData previousRun() {
                return new TestRunData();
            }

            @Override
            public Set<UniqueId> previousFailures() {
                return Collections.emptySet();
            }
        };
    }

    private TestEngineConfiguration testEngineConfigurationFromDatabase(String databasePath) {
        final TestRunDatabase database = new TestRunDatabase(Paths.get(databasePath, new String[0]));
        final TestRunData previousRun = database.previousRun();
        return new TestEngineConfiguration(){

            @Override
            public TestRunRecorder recorder() {
                return database.recorder();
            }

            @Override
            public TestRunData previousRun() {
                return database.previousRun();
            }

            @Override
            public Set<UniqueId> previousFailures() {
                if (!DefaultJqwikConfiguration.this.properties.runFailuresFirst()) {
                    return Collections.emptySet();
                }
                return previousRun.allNonSuccessfulTests().map(TestRun::getUniqueId).collect(Collectors.toSet());
            }
        };
    }
}

