/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.reporting;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.jqwik.api.JqwikException;

class ParameterChangesDetector {
    ParameterChangesDetector() {
    }

    static boolean haveParametersChanged(List<Object> before, List<Object> after) {
        return ParameterChangesDetector.atLeastOneParameterHasChanged(before, after);
    }

    private static boolean atLeastOneParameterHasChanged(List<Object> before, List<Object> after) {
        List hasEqualsImplementation = before.stream().map(o -> Objects.isNull(o) ? Object.class : o.getClass()).map(ParameterChangesDetector::hasOwnEqualsImplementation).collect(Collectors.toList());
        for (int i = 0; i < hasEqualsImplementation.size(); ++i) {
            Object beforeValue = before.get(i);
            Object afterValue = after.get(i);
            if (Objects.isNull(beforeValue) != Objects.isNull(afterValue)) {
                return true;
            }
            if (!((Boolean)hasEqualsImplementation.get(i)).booleanValue() || Objects.equals(beforeValue, afterValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOwnEqualsImplementation(Class<?> aClass) {
        if (Proxy.isProxyClass(aClass)) {
            return false;
        }
        return !ParameterChangesDetector.equalsMethod(aClass).equals(ParameterChangesDetector.equalsMethod(Object.class));
    }

    private static Method equalsMethod(Class<?> aClass) {
        try {
            return aClass.getMethod("equals", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new JqwikException("All classes should have an equals() method");
        }
    }
}

