/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.Store;

class Memoize {
    private static final Store<Map<Tuple.Tuple3<Arbitrary<?>, Integer, Boolean>, RandomGenerator<?>>> generatorStore = Memoize.createStore();

    Memoize() {
    }

    private static Store<Map<Tuple.Tuple3<Arbitrary<?>, Integer, Boolean>, RandomGenerator<?>>> createStore() {
        return Store.create(Memoize.class, (Lifespan)Lifespan.PROPERTY, HashMap::new);
    }

    static <U> RandomGenerator<U> memoizedGenerator(Arbitrary<U> arbitrary, int genSize, boolean withEdgeCases, Supplier<RandomGenerator<U>> generatorSupplier) {
        Tuple.Tuple3 key = Tuple.of(arbitrary, (Object)genSize, (Object)withEdgeCases);
        RandomGenerator generator = Memoize.computeIfAbsent((Map)generatorStore.get(), key, ignore -> (RandomGenerator)generatorSupplier.get());
        return generator;
    }

    private static <K, V> V computeIfAbsent(Map<K, V> cache, K key, Function<? super K, ? extends V> mappingFunction) {
        V result = cache.get(key);
        if (result == null) {
            result = mappingFunction.apply(key);
            cache.put(key, result);
        }
        return result;
    }
}

