/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.GenericEdgeCasesConfiguration;
import net.jqwik.engine.properties.arbitraries.randomized.RandomDecimalGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;

class DecimalEdgeCasesConfiguration
extends GenericEdgeCasesConfiguration<BigDecimal> {
    private final Range<BigDecimal> range;
    private final int scale;
    private final BigDecimal shrinkingTarget;

    public DecimalEdgeCasesConfiguration(Range<BigDecimal> range, int scale, BigDecimal shrinkingTarget) {
        this.range = range;
        this.scale = scale;
        this.shrinkingTarget = shrinkingTarget;
    }

    @Override
    protected Shrinkable<BigDecimal> createShrinkable(BigDecimal additionalEdgeCase) {
        Range<BigInteger> bigIntegerRange = RandomDecimalGenerators.unscaledBigIntegerRange(this.range, this.scale);
        BigInteger bigIntegerValue = RandomDecimalGenerators.unscaledBigInteger(additionalEdgeCase, this.scale);
        BigInteger integralShrinkingTarget = RandomDecimalGenerators.unscaledBigInteger(this.shrinkingTarget, this.scale);
        return new ShrinkableBigInteger(bigIntegerValue, bigIntegerRange, integralShrinkingTarget).map(bigInteger -> RandomDecimalGenerators.scaledBigDecimal(bigInteger, this.scale));
    }
}

