/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.Consumer;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.FloatArbitrary;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.DecimalGeneratingArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.MappedEdgeCasesConsumer;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;

public class DefaultFloatArbitrary
extends TypedCloneable
implements FloatArbitrary {
    private static final float DEFAULT_MIN = -3.4028235E38f;
    private static final float DEFAULT_MAX = Float.MAX_VALUE;
    private DecimalGeneratingArbitrary generatingArbitrary = new DecimalGeneratingArbitrary(Range.of(this.toBigDecimal(-3.4028235E38f), this.toBigDecimal(Float.MAX_VALUE)));

    public RandomGenerator<Float> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize).map(BigDecimal::floatValue);
    }

    public Optional<ExhaustiveGenerator<Float>> exhaustive(long maxNumberOfSamples) {
        return this.generatingArbitrary.exhaustive(maxNumberOfSamples).map(generator -> generator.map(BigDecimal::floatValue));
    }

    public EdgeCases<Float> edgeCases(int maxEdgeCases) {
        return EdgeCasesSupport.map(this.generatingArbitrary.edgeCases(maxEdgeCases), BigDecimal::floatValue);
    }

    public Arbitrary<Float> edgeCases(Consumer<EdgeCases.Config<Float>> configurator) {
        MappedEdgeCasesConsumer<Float, BigDecimal> decimalConfigurator = new MappedEdgeCasesConsumer<Float, BigDecimal>(configurator, BigDecimal::floatValue, val -> BigDecimal.valueOf(val.floatValue()));
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary = (DecimalGeneratingArbitrary)this.generatingArbitrary.edgeCases(decimalConfigurator);
        return clone;
    }

    public FloatArbitrary withDistribution(RandomDistribution distribution) {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary.distribution = distribution;
        return clone;
    }

    public FloatArbitrary between(float min, boolean minIncluded, float max, boolean maxIncluded) {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary.range = Range.of(this.toBigDecimal(min), minIncluded, this.toBigDecimal(max), maxIncluded);
        return clone;
    }

    public FloatArbitrary greaterOrEqual(float min) {
        return this.between(min, true, ((BigDecimal)this.generatingArbitrary.range.max).floatValue(), this.generatingArbitrary.range.maxIncluded);
    }

    public FloatArbitrary greaterThan(float min) {
        return this.between(min, false, ((BigDecimal)this.generatingArbitrary.range.max).floatValue(), this.generatingArbitrary.range.maxIncluded);
    }

    public FloatArbitrary lessOrEqual(float max) {
        return this.between(((BigDecimal)this.generatingArbitrary.range.min).floatValue(), this.generatingArbitrary.range.minIncluded, max, true);
    }

    public FloatArbitrary lessThan(float max) {
        return this.between(((BigDecimal)this.generatingArbitrary.range.min).floatValue(), this.generatingArbitrary.range.minIncluded, max, false);
    }

    public FloatArbitrary ofScale(int scale) {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary.scale = scale;
        return clone;
    }

    public FloatArbitrary shrinkTowards(float target) {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = BigDecimal.valueOf(target);
        return clone;
    }

    private BigDecimal toBigDecimal(float value) {
        return new BigDecimal(Float.toString(value));
    }
}

