/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;

public class GenericEdgeCasesConfiguration<T>
implements EdgeCases.Config<T> {
    private boolean none;
    private final List<Predicate<T>> filters = new ArrayList<Predicate<T>>();
    private final List<T> additionalEdgeCases = new ArrayList<T>();

    public EdgeCases.Config<T> none() {
        this.none = true;
        return this;
    }

    public EdgeCases.Config<T> filter(Predicate<T> filter) {
        this.filters.add(filter);
        return this;
    }

    @SafeVarargs
    public final EdgeCases.Config<T> add(T ... edgeCases) {
        this.additionalEdgeCases.addAll(Arrays.asList(edgeCases));
        return this;
    }

    @SafeVarargs
    public final EdgeCases.Config<T> includeOnly(T ... includedValues) {
        List<T> values = Arrays.asList(includedValues);
        return this.filter(values::contains);
    }

    public EdgeCases<T> configure(Consumer<EdgeCases.Config<T>> configurator, EdgeCases<T> defaultEdgeCases) {
        configurator.accept(this);
        EdgeCases configuredEdgeCases = defaultEdgeCases;
        if (this.none) {
            configuredEdgeCases = EdgeCases.none();
        }
        List suppliers = configuredEdgeCases.suppliers();
        for (Predicate filter : new ArrayList<Predicate<T>>(this.filters)) {
            suppliers = suppliers.stream().filter((? super T s) -> filter.test(((Shrinkable)s.get()).value())).collect(Collectors.toList());
        }
        for (Predicate<T> additionalEdgeCase : this.additionalEdgeCases) {
            suppliers.add(() -> this.createShrinkable(additionalEdgeCase));
        }
        return EdgeCasesSupport.fromSuppliers(suppliers);
    }

    protected Shrinkable<T> createShrinkable(T additionalEdgeCase) {
        return Shrinkable.unshrinkable(additionalEdgeCase);
    }
}

