/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.engine.SourceOfRandomness;
import net.jqwik.engine.execution.lifecycle.OutsideJqwikException;
import net.jqwik.engine.properties.shrinking.LazyOfShrinkable;
import net.jqwik.engine.support.JqwikStreamSupport;

public class LazyOfArbitrary<T>
implements Arbitrary<T> {
    private static final Store<Map<Integer, LazyOfArbitrary<?>>> cachedArbitraries = LazyOfArbitrary.createArbitrariesStore();
    private final List<Supplier<Arbitrary<T>>> suppliers;
    private final Deque<Set<LazyOfShrinkable<T>>> generatedParts = new ArrayDeque<Set<LazyOfShrinkable<T>>>();
    private final Store<Map<Integer, RandomGenerator<T>>> generators = this.createGeneratorsStore();

    private static Store<Map<Integer, LazyOfArbitrary<?>>> createArbitrariesStore() {
        try {
            return Store.create((Object)Tuple.of(LazyOfShrinkable.class, (Object)"arbitraries"), (Lifespan)Lifespan.PROPERTY, HashMap::new);
        }
        catch (OutsideJqwikException outsideJqwikException) {
            return Store.free(HashMap::new);
        }
    }

    public static <T> Arbitrary<T> of(int hashIdentifier, List<Supplier<Arbitrary<T>>> suppliers) {
        LazyOfArbitrary arbitrary = ((Map)cachedArbitraries.get()).computeIfAbsent(hashIdentifier, ignore -> new LazyOfArbitrary(suppliers));
        return arbitrary;
    }

    private Store<Map<Integer, RandomGenerator<T>>> createGeneratorsStore() {
        try {
            return Store.getOrCreate((Object)Tuple.of((Object)this, (Object)"generators"), (Lifespan)Lifespan.TRY, HashMap::new);
        }
        catch (OutsideJqwikException outsideJqwikException) {
            return Store.free(HashMap::new);
        }
    }

    public LazyOfArbitrary(List<Supplier<Arbitrary<T>>> suppliers) {
        this.suppliers = suppliers;
    }

    public RandomGenerator<T> generator(int genSize) {
        return random -> {
            int index = random.nextInt(this.suppliers.size());
            long seed = random.nextLong();
            Tuple.Tuple2<Shrinkable<T>, Set<LazyOfShrinkable<T>>> shrinkableAndParts = this.generateCurrent(genSize, index, seed);
            return this.createShrinkable(shrinkableAndParts, genSize, seed, Collections.singleton(index));
        };
    }

    private LazyOfShrinkable<T> createShrinkable(Tuple.Tuple2<Shrinkable<T>, Set<LazyOfShrinkable<T>>> shrinkableAndParts, int genSize, long seed, Set<Integer> usedIndices) {
        Shrinkable shrinkable = (Shrinkable)shrinkableAndParts.get1();
        Set parts = (Set)shrinkableAndParts.get2();
        LazyOfShrinkable lazyOfShrinkable = new LazyOfShrinkable(shrinkable, this.depth(parts), parts, lazyOf -> this.shrink((LazyOfShrinkable<T>)lazyOf, genSize, seed, usedIndices));
        this.addGenerated(lazyOfShrinkable);
        return lazyOfShrinkable;
    }

    private void addGenerated(LazyOfShrinkable<T> lazyOfShrinkable) {
        if (this.peekGenerated() != null) {
            this.peekGenerated().add(lazyOfShrinkable);
        }
    }

    private Set<LazyOfShrinkable<T>> peekGenerated() {
        return this.generatedParts.peekFirst();
    }

    private void pushGeneratedLevel() {
        this.generatedParts.addFirst(new HashSet());
    }

    private void popGeneratedLevel() {
        this.generatedParts.removeFirst();
    }

    private int depth(Set<LazyOfShrinkable<T>> parts) {
        return parts.stream().mapToInt(p -> p.depth).map(depth -> depth + 1).max().orElse(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple.Tuple2<Shrinkable<T>, Set<LazyOfShrinkable<T>>> generateCurrent(int genSize, int index, long seed) {
        try {
            this.pushGeneratedLevel();
            Tuple.Tuple2 tuple2 = Tuple.of((Object)this.getGenerator(index, genSize).next(SourceOfRandomness.newRandom(seed)), this.peekGenerated());
            return tuple2;
        }
        finally {
            this.popGeneratedLevel();
        }
    }

    private RandomGenerator<T> getGenerator(int index, int genSize) {
        if (((Map)this.generators.get()).get(index) == null) {
            RandomGenerator generator = this.suppliers.get(index).get().generator(genSize);
            ((Map)this.generators.get()).put(index, generator);
        }
        return (RandomGenerator)((Map)this.generators.get()).get(index);
    }

    private Stream<Shrinkable<T>> shrink(LazyOfShrinkable<T> lazyOf, int genSize, long seed, Set<Integer> usedIndexes) {
        return JqwikStreamSupport.concat(this.shrinkToParts(lazyOf), this.shrinkCurrent(lazyOf, genSize, seed, usedIndexes), this.shrinkToAlternatives(lazyOf.current, genSize, seed, usedIndexes));
    }

    private Stream<Shrinkable<T>> shrinkCurrent(LazyOfShrinkable<T> lazyOf, int genSize, long seed, Set<Integer> usedIndexes) {
        return lazyOf.current.shrink().map(shrinkable -> new LazyOfShrinkable(shrinkable, lazyOf.depth, Collections.emptySet(), lazy -> this.shrink((LazyOfShrinkable<T>)lazy, genSize, seed, usedIndexes)));
    }

    private Stream<Shrinkable<T>> shrinkToParts(LazyOfShrinkable<T> lazyOf) {
        return JqwikStreamSupport.concat(lazyOf.parts.stream().flatMap(this::shrinkToParts), lazyOf.parts.stream().map(s -> s));
    }

    private Stream<Shrinkable<T>> shrinkToAlternatives(Shrinkable<T> current, int genSize, long seed, Set<Integer> usedIndexes) {
        ShrinkingDistance distance = current.distance();
        HashSet<Integer> newUsedIndexes = new HashSet<Integer>(usedIndexes);
        return IntStream.range(0, this.suppliers.size()).filter(index -> !usedIndexes.contains(index)).peek(newUsedIndexes::add).mapToObj(index -> this.generateCurrent(genSize, index, seed)).filter(shrinkableAndParts -> ((Shrinkable)shrinkableAndParts.get1()).distance().compareTo(distance) < 0).map(shrinkableAndParts -> this.createShrinkable((Tuple.Tuple2<Shrinkable<T>, Set<LazyOfShrinkable<T>>>)shrinkableAndParts, genSize, seed, (Set<Integer>)newUsedIndexes));
    }

    private Stream<Shrinkable<T>> shrinkToAlternativesAndGrow(Shrinkable<T> current, int genSize, long seed, Set<Integer> usedIndexes) {
        ShrinkingDistance distance = current.distance();
        HashSet<Integer> newUsedIndexes = new HashSet<Integer>(usedIndexes);
        return IntStream.range(0, this.suppliers.size()).filter(index -> !usedIndexes.contains(index)).peek(newUsedIndexes::add).mapToObj(index -> this.generateCurrent(genSize, index, seed)).map(Tuple.Tuple1::get1).filter(tShrinkable -> tShrinkable.distance().compareTo(distance) < 0).flatMap(Shrinkable::grow).filter(shrinkable -> shrinkable.distance().compareTo(distance) < 0).map(grownShrinkable -> this.createShrinkable(Tuple.of((Object)grownShrinkable, Collections.emptySet()), genSize, seed, newUsedIndexes));
    }

    public EdgeCases<T> edgeCases(int maxEdgeCases) {
        return EdgeCases.none();
    }
}

