/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.MaxTriesLoop;

public class FilteredExhaustiveGenerator<T>
implements ExhaustiveGenerator<T> {
    private final ExhaustiveGenerator<T> toFilter;
    private final Predicate<T> filter;

    public FilteredExhaustiveGenerator(ExhaustiveGenerator<T> toFilter, Predicate<T> filter) {
        this.toFilter = toFilter;
        this.filter = filter;
    }

    public long maxCount() {
        return this.toFilter.maxCount();
    }

    public Iterator<T> iterator() {
        final Iterator mappedIterator = this.toFilter.iterator();
        return new Iterator<T>(){
            T next = this.findNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = this.findNext();
                return result;
            }

            private T findNext() {
                return MaxTriesLoop.loop(() -> true, next -> {
                    if (!mappedIterator.hasNext()) {
                        return Tuple.of((Object)true, null);
                    }
                    next = mappedIterator.next();
                    if (FilteredExhaustiveGenerator.this.filter.test(next)) {
                        return Tuple.of((Object)true, (Object)next);
                    }
                    return Tuple.of((Object)false, (Object)next);
                }, maxMisses -> {
                    String message = String.format("Filter missed more than %s times.", maxMisses);
                    return new TooManyFilterMissesException(message);
                });
            }
        };
    }
}

