/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.engine.SourceOfRandomness;

public class InjectDuplicatesGenerator<T>
implements RandomGenerator<T> {
    private final Store<List<Long>> previousSeeds = Store.create((Object)this, (Lifespan)Lifespan.TRY, ArrayList::new);
    private final RandomGenerator<T> base;
    private final double duplicateProbability;

    public InjectDuplicatesGenerator(RandomGenerator<T> base, double duplicateProbability) {
        this.base = base;
        this.duplicateProbability = duplicateProbability;
    }

    public Shrinkable<T> next(Random random) {
        long seed = this.chooseSeed(random);
        return this.base.next(SourceOfRandomness.newRandom(seed));
    }

    long chooseSeed(Random random) {
        if (!((List)this.previousSeeds.get()).isEmpty() && random.nextDouble() <= this.duplicateProbability) {
            return this.randomPreviousSeed(random);
        }
        long seed = random.nextLong();
        ((List)this.previousSeeds.get()).add(seed);
        return seed;
    }

    private long randomPreviousSeed(Random random) {
        int index = random.nextInt(((List)this.previousSeeds.get()).size());
        return (Long)((List)this.previousSeeds.get()).get(index);
    }
}

