/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.configurators;

import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ByteArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.constraints.ByteRange;
import net.jqwik.api.providers.TypeUsage;

public class ByteRangeConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.isAssignableFrom(Byte.class);
    }

    public Arbitrary<Byte> configure(Arbitrary<Byte> arbitrary, ByteRange range) {
        if (arbitrary instanceof ByteArbitrary) {
            ByteArbitrary byteArbitrary = (ByteArbitrary)arbitrary;
            return byteArbitrary.greaterOrEqual(range.min()).lessOrEqual(range.max());
        }
        return arbitrary.filter(i -> i >= range.min() && i <= range.max());
    }
}

