/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.support.JqwikStreamSupport;

public class FilteredShrinkable<T>
implements Shrinkable<T> {
    private static final int MAX_BASE_SHRINKS = 100;
    private final AtomicInteger countBaseShrinks = new AtomicInteger(0);
    private final Shrinkable<T> toFilter;
    private final Predicate<T> filter;

    public FilteredShrinkable(Shrinkable<T> toFilter, Predicate<T> filter) {
        this.toFilter = toFilter;
        this.filter = filter;
    }

    public T value() {
        return (T)this.toFilter.value();
    }

    public Stream<Shrinkable<T>> shrink() {
        return Stream.concat(this.shrinkToFirst(this.toFilter), this.shrinkDeep(this.toFilter));
    }

    public Optional<Shrinkable<T>> grow(Shrinkable<?> before, Shrinkable<?> after) {
        if (before instanceof FilteredShrinkable && after instanceof FilteredShrinkable) {
            Shrinkable<T> beforeToFilter = ((FilteredShrinkable)before).toFilter;
            Shrinkable<T> afterToFilter = ((FilteredShrinkable)after).toFilter;
            return this.toFilter.grow(beforeToFilter, afterToFilter).filter(this::isIncluded).map(this::toFiltered);
        }
        return this.toFilter.grow(before, after).filter(this::isIncluded).map(this::toFiltered);
    }

    private Stream<Shrinkable<T>> shrinkToFirst(Shrinkable<T> base) {
        return base.shrink().peek(ignore -> this.countBaseShrinks.incrementAndGet()).filter(this::isIncluded).map(this::toFiltered);
    }

    private Stream<Shrinkable<T>> shrinkDeep(Shrinkable<T> base) {
        Stream<Shrinkable> constrainedBaseShrink = JqwikStreamSupport.takeWhile(base.shrink(), ignore -> this.countBaseShrinks.get() < 100);
        return JqwikStreamSupport.concat(base.shrink().flatMap(this::shrinkToFirst), constrainedBaseShrink.flatMap(this::shrinkDeep).limit(1L));
    }

    public Stream<Shrinkable<T>> grow() {
        return Stream.concat(this.growToFirst(this.toFilter), this.growDeep(this.toFilter)).limit(50L).distinct();
    }

    private Stream<Shrinkable<T>> growToFirst(Shrinkable<T> base) {
        return base.grow().filter(this::isIncluded).map(this::toFiltered);
    }

    private Stream<Shrinkable<T>> growDeep(Shrinkable<T> base) {
        return Stream.concat(base.grow().flatMap(this::growToFirst), base.grow().flatMap(this::growDeep));
    }

    private boolean isIncluded(Shrinkable<T> shrinkable) {
        return this.filter.test(shrinkable.value());
    }

    private Shrinkable<T> toFiltered(Shrinkable<T> t) {
        return new FilteredShrinkable<T>(t, this.filter);
    }

    public ShrinkingDistance distance() {
        return this.toFilter.distance();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredShrinkable that = (FilteredShrinkable)o;
        return this.toFilter.equals(that.toFilter);
    }

    public int hashCode() {
        return this.toFilter.hashCode();
    }

    public String toString() {
        return String.format("Filtered|%s", this.toFilter);
    }
}

