/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.support.GenericsClassContext;
import net.jqwik.engine.support.GenericsSupport;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.MethodParameter;
import net.jqwik.engine.support.OverriddenMethodAnnotationSupport;
import net.jqwik.engine.support.TypeResolution;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;

public class JqwikReflectionSupport {
    public static Stream<Object> streamInstancesFromInside(Object inner) {
        return JqwikReflectionSupport.addInstances(inner, new ArrayList<Object>()).stream();
    }

    private static List<Object> addInstances(Object inner, List<Object> instances) {
        instances.add(inner);
        Optional<Object> outer = JqwikReflectionSupport.getOuterInstance(inner);
        outer.ifPresent(o -> JqwikReflectionSupport.addInstances(o, instances));
        return instances;
    }

    private static Optional<Object> getOuterInstance(Object inner) {
        return Arrays.stream(inner.getClass().getDeclaredFields()).filter(field -> field.getName().startsWith("this$")).findFirst().map(field -> {
            try {
                return JqwikReflectionSupport.makeAccessible(field).get(inner);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                return Optional.empty();
            }
        });
    }

    private static <T extends AccessibleObject> T makeAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }

    public static <T> T newInstanceWithDefaultConstructor(Class<T> clazz) {
        if (JqwikReflectionSupport.isInnerClass(clazz)) {
            Object parentInstance = JqwikReflectionSupport.newInstanceWithDefaultConstructor(clazz.getDeclaringClass());
            return (T)ReflectionSupport.newInstance(clazz, (Object[])new Object[]{parentInstance});
        }
        return (T)ReflectionSupport.newInstance(clazz, (Object[])new Object[0]);
    }

    public static <T> T newInstanceInTestContext(Class<T> clazz, Object context) {
        if (!JqwikReflectionSupport.isInnerClass(clazz)) {
            return (T)ReflectionSupport.newInstance(clazz, (Object[])new Object[0]);
        }
        Class<?> outerClass = clazz.getDeclaringClass();
        Object parentInstance = outerClass.isAssignableFrom(context.getClass()) ? context : JqwikReflectionSupport.newInstanceWithDefaultConstructor(outerClass);
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(outerClass);
            return JqwikReflectionSupport.newInstance(constructor, parentInstance);
        }
        catch (NoSuchMethodException e) {
            return JqwikExceptionSupport.throwAsUncheckedException(e);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        try {
            return JqwikReflectionSupport.makeAccessible(constructor).newInstance(args);
        }
        catch (Throwable t) {
            return JqwikExceptionSupport.throwAsUncheckedException(t);
        }
    }

    public static List<Method> findMethodsPotentiallyOuter(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        List<Class<?>> searchClasses = JqwikReflectionSupport.getDeclaringClasses(clazz, traversalMode);
        ArrayList<Method> foundMethods = new ArrayList<Method>();
        for (Class<?> searchClass : searchClasses) {
            foundMethods.addAll(ReflectionSupport.findMethods(searchClass, predicate, (HierarchyTraversalMode)traversalMode));
        }
        return foundMethods;
    }

    private static List<Class<?>> getDeclaringClasses(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        ArrayList declaringClasses = new ArrayList();
        for (Class<?> nextClass = clazz; nextClass != null; nextClass = nextClass.getDeclaringClass()) {
            if (traversalMode == HierarchyTraversalMode.BOTTOM_UP) {
                declaringClasses.add(nextClass);
                continue;
            }
            declaringClasses.add(0, nextClass);
        }
        return declaringClasses;
    }

    public static Object invokeMethodPotentiallyOuter(Method method, Object target, Object ... args) {
        Optional<Object> newTarget;
        if (method.getDeclaringClass().isAssignableFrom(target.getClass())) {
            return ReflectionSupport.invokeMethod((Method)method, (Object)target, (Object[])args);
        }
        if (target.getClass().getDeclaringClass() != null && (newTarget = JqwikReflectionSupport.getOuterInstance(target)).isPresent()) {
            return JqwikReflectionSupport.invokeMethodPotentiallyOuter(method, newTarget.get(), args);
        }
        throw new IllegalArgumentException(String.format("Method [%s] cannot be invoked on target [%s].", method, target));
    }

    public static Set<Path> getAllClasspathRootDirectories() {
        String classpath = System.getProperty("java.class.path");
        return Arrays.stream(classpath.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toSet());
    }

    public static List<MethodParameter> getMethodParameters(Method method, Class<?> containerClass) {
        ArrayList<MethodParameter> list = new ArrayList<MethodParameter>();
        Parameter[] parameters = method.getParameters();
        GenericsClassContext containerClassContext = GenericsSupport.contextFor(containerClass);
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            TypeResolution resolution = containerClassContext.resolveParameter(parameter);
            MethodParameter methodParameter = new MethodParameter(parameter, resolution, i);
            list.add(methodParameter);
        }
        return list;
    }

    public static MethodParameter getMethodParameter(Parameter parameter, int index, Class<?> containerClass) {
        GenericsClassContext containerClassContext = GenericsSupport.contextFor(containerClass);
        TypeResolution resolution = containerClassContext.resolveParameter(parameter);
        return new MethodParameter(parameter, resolution, index);
    }

    public static Optional<Method> findGeneratorMethod(String generatorToFind, Class<?> containerClass, Class<? extends Annotation> requiredGeneratorAnnotation, Function<Method, String> generatorNameSupplier, TypeUsage targetType) {
        List<Method> creators = JqwikReflectionSupport.findMethodsPotentiallyOuter(containerClass, JqwikReflectionSupport.isGeneratorMethod(targetType, requiredGeneratorAnnotation), HierarchyTraversalMode.BOTTOM_UP);
        return creators.stream().filter(generatorMethod -> {
            String generatorName = (String)generatorNameSupplier.apply((Method)generatorMethod);
            if (generatorName.isEmpty()) {
                generatorName = generatorMethod.getName();
            }
            return generatorName.equals(generatorToFind);
        }).findFirst();
    }

    public static <T> Constructor<T> findConstructor(Class<T> type, Class<?> ... parameterTypes) {
        try {
            Constructor<T> ctor = type.getDeclaredConstructor(parameterTypes);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (Throwable t) {
            return (Constructor)JqwikExceptionSupport.throwAsUncheckedException(t);
        }
    }

    public static Predicate<Method> isGeneratorMethod(TypeUsage targetType, Class<? extends Annotation> requiredAnnotation) {
        return method -> {
            if (!OverriddenMethodAnnotationSupport.findDeclaredOrInheritedAnnotation(method, requiredAnnotation).isPresent()) {
                return false;
            }
            TypeUsage generatorReturnType = TypeUsage.forType((Type)method.getAnnotatedReturnType().getType());
            return generatorReturnType.canBeAssignedTo(targetType) || targetType.canBeAssignedTo(generatorReturnType);
        };
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !ModifierSupport.isStatic(clazz);
    }

    public static boolean isFunctionalType(Class<?> candidateType) {
        if (!candidateType.isInterface()) {
            return false;
        }
        return JqwikReflectionSupport.countInterfaceMethods(candidateType) == 1L;
    }

    private static long countInterfaceMethods(Class<?> candidateType) {
        Method[] methods = candidateType.getMethods();
        return JqwikReflectionSupport.findInterfaceMethods(methods).size();
    }

    private static List<Method> findInterfaceMethods(Method[] methods) {
        return Arrays.stream(methods).filter(m -> !m.isDefault() && !ModifierSupport.isStatic((Member)m)).collect(Collectors.toList());
    }

    public static Optional<Method> getFunctionMethod(Class<?> candidateType) {
        Method[] methods = candidateType.getMethods();
        List<Method> candidates = JqwikReflectionSupport.findInterfaceMethods(methods);
        if (candidates.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(candidates.get(0));
    }

    public static boolean isEqualsMethod(Method method) {
        try {
            return method.equals(Object.class.getDeclaredMethod("equals", Object.class));
        }
        catch (NoSuchMethodException shouldNeverHappen) {
            return false;
        }
    }

    public static boolean isToStringMethod(Method method) {
        try {
            return method.equals(Object.class.getDeclaredMethod("toString", new Class[0]));
        }
        catch (NoSuchMethodException shouldNeverHappen) {
            return false;
        }
    }

    public static boolean isHashCodeMethod(Method method) {
        try {
            return method.equals(Object.class.getDeclaredMethod("hashCode", new Class[0]));
        }
        catch (NoSuchMethodException shouldNeverHappen) {
            return false;
        }
    }

    public static boolean hasDefaultConstructor(Class<?> aClass) {
        try {
            aClass.getDeclaredConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean isJava9orAbove() {
        try {
            Runtime.class.getMethod("version", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean isStatic(Class<?> clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isNotStatic(Class<?> clazz) {
        return !JqwikReflectionSupport.isStatic(clazz);
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isNotStatic(Member member) {
        return !JqwikReflectionSupport.isStatic(member);
    }

    public static boolean returnsVoid(Method method) {
        return method.getReturnType().equals(Void.TYPE);
    }

    public static boolean isInternalKotlinMethod(Method method) {
        Class<?> aClass = method.getDeclaringClass();
        return JqwikReflectionSupport.isKotlinClass(aClass) && JqwikReflectionSupport.isKotlinInternal(method);
    }

    private static boolean isKotlinInternal(Method method) {
        return method.getName().lastIndexOf(36) > 0;
    }

    public static boolean isKotlinClass(Class<?> aClass) {
        for (Annotation annotation : aClass.getDeclaredAnnotations()) {
            if (!annotation.annotationType().getTypeName().equals("kotlin.Metadata")) continue;
            return true;
        }
        return false;
    }
}

