/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.jqwik.engine.execution.lifecycle.OutsideJqwikException;
import org.junit.platform.engine.TestDescriptor;

public class CurrentTestDescriptor {
    private static final ThreadLocal<List<TestDescriptor>> descriptors = ThreadLocal.withInitial(ArrayList::new);

    public static void runWithDescriptor(TestDescriptor currentDescriptor, Runnable executable) {
        Supplier<Void> supplier = () -> {
            executable.run();
            return null;
        };
        CurrentTestDescriptor.runWithDescriptor(currentDescriptor, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithDescriptor(TestDescriptor currentDescriptor, Supplier<T> executable) {
        CurrentTestDescriptor.push(currentDescriptor);
        try {
            T t = executable.get();
            return t;
        }
        finally {
            TestDescriptor peek = descriptors.get().get(0);
            if (peek == currentDescriptor) {
                CurrentTestDescriptor.pop();
            }
        }
    }

    private static TestDescriptor pop() {
        return descriptors.get().remove(0);
    }

    private static void push(TestDescriptor currentDescriptor) {
        descriptors.get().add(0, currentDescriptor);
    }

    public static boolean isEmpty() {
        return descriptors.get().isEmpty();
    }

    public static TestDescriptor get() {
        if (CurrentTestDescriptor.isEmpty()) {
            String message = String.format("The current action must be run on a jqwik thread, i.e. container, property or hook.%nMaybe you spawned off a thread?", new Object[0]);
            throw new OutsideJqwikException(message);
        }
        return descriptors.get().get(0);
    }
}

