/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.api.JqwikException;
import net.jqwik.api.lifecycle.AfterContainerHook;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.AroundTryHook;
import net.jqwik.api.lifecycle.BeforeContainerHook;
import net.jqwik.api.lifecycle.LifecycleHook;
import net.jqwik.api.lifecycle.PropagationMode;
import net.jqwik.api.lifecycle.RegistrarHook;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.SkipExecutionHook;
import net.jqwik.engine.descriptor.JqwikDescriptor;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.lifecycle.CurrentTestDescriptor;
import net.jqwik.engine.execution.lifecycle.HookSupport;
import net.jqwik.engine.execution.lifecycle.LifecycleHooksSupplier;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.TestDescriptor;

public class LifecycleHooksRegistry
implements LifecycleHooksSupplier {
    private static final Logger LOG = Logger.getLogger(LifecycleHooksRegistry.class.getName());
    private final List<HookRegistration> registrations = new ArrayList<HookRegistration>();
    private final Map<Class<? extends LifecycleHook>, LifecycleHook> instances = new HashMap<Class<? extends LifecycleHook>, LifecycleHook>();

    private static <T extends LifecycleHook> Comparator<T> dontCompare() {
        return (a, b) -> 0;
    }

    @Override
    public AroundPropertyHook aroundPropertyHook(PropertyMethodDescriptor propertyMethodDescriptor) {
        List<AroundPropertyHook> aroundPropertyHooks = this.findHooks(propertyMethodDescriptor, AroundPropertyHook.class, AroundPropertyHook::compareTo);
        return HookSupport.combineAroundPropertyHooks(aroundPropertyHooks);
    }

    @Override
    public AroundTryHook aroundTryHook(PropertyMethodDescriptor propertyMethodDescriptor) {
        List<AroundTryHook> aroundTryHooks = this.findHooks(propertyMethodDescriptor, AroundTryHook.class, AroundTryHook::compareTo);
        return HookSupport.combineAroundTryHooks(aroundTryHooks);
    }

    @Override
    public BeforeContainerHook beforeContainerHook(TestDescriptor descriptor) {
        List<BeforeContainerHook> beforeContainerHooks = this.findHooks(descriptor, BeforeContainerHook.class, BeforeContainerHook::compareTo);
        return HookSupport.combineBeforeContainerHooks(beforeContainerHooks);
    }

    @Override
    public AfterContainerHook afterContainerHook(TestDescriptor descriptor) {
        List<AfterContainerHook> afterContainerHooks = this.findHooks(descriptor, AfterContainerHook.class, AfterContainerHook::compareTo);
        return HookSupport.combineAfterContainerHooks(afterContainerHooks);
    }

    @Override
    public ResolveParameterHook resolveParameterHook(TestDescriptor descriptor) {
        List<ResolveParameterHook> resolveParameterHooks = this.findHooks(descriptor, ResolveParameterHook.class, LifecycleHooksRegistry.dontCompare());
        return HookSupport.combineResolveParameterHooks(resolveParameterHooks);
    }

    @Override
    public SkipExecutionHook skipExecutionHook(TestDescriptor testDescriptor) {
        List<SkipExecutionHook> skipExecutionHooks = this.findHooks(testDescriptor, SkipExecutionHook.class, LifecycleHooksRegistry.dontCompare());
        return HookSupport.combineSkipExecutionHooks(skipExecutionHooks);
    }

    private <T extends LifecycleHook> List<T> findHooks(TestDescriptor descriptor, Class<T> hookType, Comparator<T> comparator) {
        List<Class<T>> hookClasses = this.findHookClasses(descriptor, hookType);
        return hookClasses.stream().map(this::getHook).filter(hook -> this.hookAppliesTo(hook, descriptor)).sorted(comparator).collect(Collectors.toList());
    }

    private <T extends LifecycleHook> boolean hookAppliesTo(T hook, TestDescriptor descriptor) {
        Optional<AnnotatedElement> element = this.elementFor(descriptor);
        return hook.appliesTo(element);
    }

    private Optional<AnnotatedElement> elementFor(TestDescriptor descriptor) {
        Optional<AnnotatedElement> element = Optional.empty();
        if (descriptor instanceof JqwikDescriptor) {
            element = Optional.of(((JqwikDescriptor)descriptor).getAnnotatedElement());
        }
        return element;
    }

    public <T extends LifecycleHook> boolean hasHook(TestDescriptor descriptor, Class<T> concreteHook) {
        List<LifecycleHook> hooks = this.findHooks(descriptor, LifecycleHook.class, LifecycleHooksRegistry.dontCompare());
        return hooks.stream().anyMatch(hook -> hook.getClass().equals(concreteHook));
    }

    private <T extends LifecycleHook> T getHook(Class<T> hookClass) {
        return (T)this.instances.get(hookClass);
    }

    private <T extends LifecycleHook> List<Class<T>> findHookClasses(TestDescriptor descriptor, Class<T> hookType) {
        return this.registrations.stream().filter(registration -> registration.match(descriptor)).filter(registration -> registration.match(hookType)).map(registration -> ((HookRegistration)registration).hookClass).distinct().collect(Collectors.toList());
    }

    void registerLifecycleInstance(TestDescriptor descriptor, LifecycleHook hookInstance) {
        Class<?> hookClass = hookInstance.getClass();
        this.createAndRegisterHook(descriptor, hookClass, hookInstance.propagateTo());
        if (!this.instances.containsKey(hookClass)) {
            this.instances.put(hookClass, hookInstance);
        }
        this.registerRegistrarHooks(descriptor, hookInstance);
    }

    private void createAndRegisterHook(TestDescriptor descriptor, Class<? extends LifecycleHook> hookClass, PropagationMode propagateTo) {
        HookRegistration registration = new HookRegistration(descriptor, hookClass, propagateTo);
        if (!this.registrations.contains(registration)) {
            this.registrations.add(registration);
        }
    }

    public void registerLifecycleHook(TestDescriptor descriptor, Class<? extends LifecycleHook> hookClass, PropagationMode propagationMode) {
        if (JqwikReflectionSupport.isInnerClass(hookClass)) {
            String message = String.format("Inner class [%s] cannot be used as LifecycleHook", hookClass.getName());
            throw new JqwikException(message);
        }
        if (!JqwikReflectionSupport.hasDefaultConstructor(hookClass)) {
            String message = String.format("Hook class [%s] must have default constructor", hookClass.getName());
            throw new JqwikException(message);
        }
        LifecycleHook hookInstance = this.instances.computeIfAbsent(hookClass, clazz -> CurrentTestDescriptor.runWithDescriptor(descriptor, () -> (LifecycleHook)ReflectionSupport.newInstance((Class)hookClass, (Object[])new Object[0])));
        PropagationMode propagateTo = propagationMode;
        if (propagateTo == PropagationMode.NOT_SET) {
            propagateTo = hookInstance.propagateTo();
        }
        this.createAndRegisterHook(descriptor, hookClass, propagateTo);
        this.registerRegistrarHooks(descriptor, hookInstance);
    }

    private void registerRegistrarHooks(TestDescriptor descriptor, LifecycleHook hookInstance) {
        if (hookInstance instanceof RegistrarHook) {
            if (hookInstance.propagateTo() != PropagationMode.NO_DESCENDANTS) {
                String warnAboutPropagationMode = String.format("RegistrarHook [%s] is propagated to descendants.%nThis does not work for registerHooks()!", hookInstance.getClass());
                LOG.warning(warnAboutPropagationMode);
            }
            RegistrarHook.Registrar registrar = (hookClass, propagationMode) -> this.registerLifecycleHook(descriptor, hookClass, propagationMode);
            ((RegistrarHook)hookInstance).registerHooks(registrar);
        }
    }

    private static class HookRegistration {
        private final TestDescriptor descriptor;
        private final Class<? extends LifecycleHook> hookClass;
        private final PropagationMode propagationMode;

        private HookRegistration(TestDescriptor descriptor, Class<? extends LifecycleHook> hookClass, PropagationMode propagationMode) {
            if (propagationMode == PropagationMode.NOT_SET) {
                throw new IllegalArgumentException("propagation mode must be set by caller");
            }
            this.descriptor = descriptor;
            this.hookClass = hookClass;
            this.propagationMode = propagationMode;
        }

        boolean match(TestDescriptor descriptor) {
            return this.match(descriptor, 0);
        }

        private boolean match(TestDescriptor descriptor, int nesting) {
            if (descriptor == null) {
                return false;
            }
            if (nesting > 0 && this.propagationMode == PropagationMode.NO_DESCENDANTS) {
                return false;
            }
            if (nesting > 1 && this.propagationMode != PropagationMode.ALL_DESCENDANTS) {
                return false;
            }
            if (this.descriptor.equals(descriptor)) {
                return true;
            }
            return this.match(descriptor.getParent().orElse(null), nesting + 1);
        }

        boolean match(Class<? extends LifecycleHook> hookType) {
            return hookType.isAssignableFrom(this.hookClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HookRegistration that = (HookRegistration)o;
            if (!this.descriptor.equals(that.descriptor)) {
                return false;
            }
            return this.hookClass.equals(that.hookClass);
        }

        public int hashCode() {
            int result = this.descriptor.hashCode();
            result = 31 * result + this.hookClass.hashCode();
            return result;
        }
    }
}

