/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Falsifier;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingMode;
import net.jqwik.api.facades.ShrinkingSupportFacade;
import net.jqwik.api.lifecycle.FalsifiedSample;
import net.jqwik.api.lifecycle.ShrunkFalsifiedSample;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.engine.facades.TestingSupportFacadeImpl;
import net.jqwik.engine.properties.FalsifiedSampleImpl;
import net.jqwik.engine.properties.shrinking.PropertyShrinker;

public class ShrinkingSupportFacadeImpl
extends ShrinkingSupportFacade {
    private final TestingSupportFacadeImpl testingSupportFacade = new TestingSupportFacadeImpl();

    public <T> T falsifyThenShrink(Arbitrary<? extends T> arbitrary, Random random, Falsifier<T> falsifier) {
        RandomGenerator generator = arbitrary.generator(10, true);
        return this.falsifyThenShrink(generator, random, falsifier);
    }

    public <T> T falsifyThenShrink(RandomGenerator<? extends T> generator, Random random, Falsifier<T> falsifier) {
        Throwable[] originalError = new Throwable[1];
        Shrinkable<Object> falsifiedShrinkable = this.testingSupportFacade.generateUntil(generator, random, value -> {
            TryExecutionResult result = falsifier.execute(value);
            if (result.isFalsified()) {
                originalError[0] = result.throwable().orElse(null);
            }
            return result.isFalsified();
        });
        return (T)this.shrink(falsifiedShrinkable, falsifier, originalError[0]);
    }

    public <T> T shrink(Shrinkable<T> falsifiedShrinkable, Falsifier<T> falsifier, Throwable originalError) {
        ShrunkFalsifiedSample sample = this.shrinkToSample(falsifiedShrinkable, falsifier, originalError);
        return (T)sample.parameters().get(0);
    }

    public <T> ShrunkFalsifiedSample shrinkToSample(Shrinkable<T> falsifiedShrinkable, Falsifier<T> falsifier, Throwable originalError) {
        FalsifiedSample sample = ShrinkingSupportFacadeImpl.toFalsifiedSample(falsifiedShrinkable, originalError);
        Consumer<FalsifiedSample> parametersReporter = ignore -> {};
        PropertyShrinker shrinker = new PropertyShrinker(sample, ShrinkingMode.FULL, 10, parametersReporter, null);
        return shrinker.shrink(ShrinkingSupportFacadeImpl.toParamFalsifier(falsifier));
    }

    private static <T> Falsifier<List<Object>> toParamFalsifier(Falsifier<T> tFalsifier) {
        return params -> {
            Object t = params.get(0);
            return tFalsifier.execute(t);
        };
    }

    private static <T> FalsifiedSample toFalsifiedSample(Shrinkable<T> falsifiedShrinkable, Throwable originalError) {
        List<Shrinkable<Object>> shrinkables = Collections.singletonList(falsifiedShrinkable);
        return ShrinkingSupportFacadeImpl.toFalsifiedSample(shrinkables, originalError);
    }

    private static FalsifiedSample toFalsifiedSample(List<Shrinkable<Object>> shrinkables, Throwable originalError) {
        List<Object> parameters = shrinkables.stream().map(Shrinkable::value).collect(Collectors.toList());
        return new FalsifiedSampleImpl(parameters, shrinkables, Optional.ofNullable(originalError));
    }
}

