/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.hooks.lifecycle;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.lifecycle.AroundTryHook;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.PropagationMode;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryExecutor;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import net.jqwik.engine.hooks.lifecycle.LifecycleMethods;
import net.jqwik.engine.hooks.lifecycle.MethodParameterResolver;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class TryLifecycleMethodsHook
implements AroundTryHook {
    private void beforeTry(TryLifecycleContext context) {
        List<Method> beforeTryMethods = LifecycleMethods.findBeforeTryMethods(context.containerClass());
        this.callTryMethods(beforeTryMethods, context);
    }

    private void callTryMethods(List<Method> methods, TryLifecycleContext context) {
        Object testInstance = context.testInstance();
        ThrowableCollector throwableCollector = new ThrowableCollector(ignore -> false);
        for (Method method : methods) {
            Object[] parameters = MethodParameterResolver.resolveParameters(method, (LifecycleContext)context);
            throwableCollector.execute(() -> this.callMethod(method, testInstance, parameters));
        }
        throwableCollector.assertEmpty();
    }

    private void callMethod(Method method, Object target, Object[] parameters) {
        JqwikReflectionSupport.invokeMethodPotentiallyOuter(method, target, parameters);
    }

    private void afterTry(TryLifecycleContext context) {
        List<Method> afterTryMethods = LifecycleMethods.findAfterTryMethods(context.containerClass());
        this.callTryMethods(afterTryMethods, context);
    }

    public PropagationMode propagateTo() {
        return PropagationMode.ALL_DESCENDANTS;
    }

    public boolean appliesTo(Optional<AnnotatedElement> element) {
        return element.map(e -> e instanceof Method).orElse(false);
    }

    public int aroundTryProximity() {
        return -10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TryExecutionResult aroundTry(TryLifecycleContext context, TryExecutor aTry, List<Object> parameters) {
        this.beforeTry(context);
        try {
            TryExecutionResult tryExecutionResult = aTry.execute(parameters);
            return tryExecutionResult;
        }
        finally {
            this.afterTry(context);
        }
    }
}

