/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.hooks.statistics;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jqwik.api.Reporter;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.PropagationMode;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.api.statistics.StatisticsReport;
import net.jqwik.api.statistics.StatisticsReportFormat;
import net.jqwik.engine.hooks.statistics.StandardStatisticsReportFormat;
import net.jqwik.engine.hooks.statistics.StatisticsCollectorImpl;
import net.jqwik.engine.hooks.statistics.StatisticsPublisher;
import net.jqwik.engine.support.JqwikAnnotationSupport;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;

public class StatisticsHook
implements AroundPropertyHook {
    private static final Supplier<Map<String, StatisticsCollectorImpl>> STATISTICS_MAP_SUPPLIER = () -> new LinkedHashMap<String, StatisticsCollectorImpl>(){

        @Override
        public StatisticsCollectorImpl get(Object key) {
            return this.computeIfAbsent((String)key, StatisticsCollectorImpl::new);
        }
    };

    public PropertyExecutionResult aroundProperty(PropertyLifecycleContext context, PropertyExecutor property) throws Throwable {
        Store collectorsStore = Store.create((Object)StatisticsCollectorImpl.COLLECTORS_ID, (Lifespan)Lifespan.PROPERTY, STATISTICS_MAP_SUPPLIER);
        PropertyExecutionResult testExecutionResult = property.execute();
        Map collectors = (Map)collectorsStore.get();
        this.createStatisticsReports(collectors, context);
        if (testExecutionResult.status() == PropertyExecutionResult.Status.SUCCESSFUL) {
            return this.checkCoverages(testExecutionResult, collectors.values());
        }
        return testExecutionResult;
    }

    private PropertyExecutionResult checkCoverages(PropertyExecutionResult testExecutionResult, Collection<StatisticsCollectorImpl> collectors) {
        try {
            for (StatisticsCollectorImpl collector : collectors) {
                collector.checkCoverage();
            }
            return testExecutionResult;
        }
        catch (Throwable throwable) {
            JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
            return testExecutionResult.mapToFailed(throwable);
        }
    }

    private void createStatisticsReports(Map<String, StatisticsCollectorImpl> collectors, PropertyLifecycleContext context) {
        List<StatisticsReport> statisticsReportAnnotations = JqwikAnnotationSupport.findRepeatableAnnotationOnElementOrContainer(context.targetMethod(), StatisticsReport.class);
        Set<Tuple.Tuple3<String, StatisticsCollectorImpl, StatisticsReportFormat>> reports = collectors.entrySet().stream().map(entry -> {
            String label = (String)entry.getKey();
            return Tuple.of((Object)label, (Object)((StatisticsCollectorImpl)entry.getValue()), (Object)this.determineFormat(label, statisticsReportAnnotations, context));
        }).collect(Collectors.toSet());
        this.report(reports, context.reporter(), context.extendedLabel());
    }

    private StatisticsReportFormat determineFormat(String label, List<StatisticsReport> statisticsReportAnnotations, PropertyLifecycleContext context) {
        boolean defaultReportFormatSet = false;
        StandardStatisticsReportFormat defaultReportFormat = new StandardStatisticsReportFormat();
        for (StatisticsReport annotation : statisticsReportAnnotations) {
            if (annotation.label().equals(label)) {
                return this.createReportFormat(annotation, context);
            }
            if (defaultReportFormatSet || !annotation.label().equals("")) continue;
            defaultReportFormat = this.createReportFormat(annotation, context);
            defaultReportFormatSet = true;
        }
        return defaultReportFormat;
    }

    private StatisticsReportFormat createReportFormat(StatisticsReport annotation, PropertyLifecycleContext context) {
        if (annotation.value() == StatisticsReport.StatisticsReportMode.OFF) {
            return null;
        }
        if (annotation.value() == StatisticsReport.StatisticsReportMode.PLUG_IN) {
            return (StatisticsReportFormat)JqwikReflectionSupport.newInstanceInTestContext(annotation.format(), context.testInstance());
        }
        return new StandardStatisticsReportFormat();
    }

    private void report(Set<Tuple.Tuple3<String, StatisticsCollectorImpl, StatisticsReportFormat>> reports, Reporter reporter, String propertyName) {
        for (Tuple.Tuple3<String, StatisticsCollectorImpl, StatisticsReportFormat> report : reports) {
            if (report.get3() == null) continue;
            StatisticsPublisher reportGenerator = new StatisticsPublisher((StatisticsCollectorImpl)report.get2(), (StatisticsReportFormat)report.get3());
            reportGenerator.publish(reporter, propertyName);
        }
    }

    public PropagationMode propagateTo() {
        return PropagationMode.ALL_DESCENDANTS;
    }

    public int aroundPropertyProximity() {
        return -50;
    }
}

