/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.facades.TypeUsageImpl;
import net.jqwik.engine.properties.ForAllParametersGenerator;
import net.jqwik.engine.properties.IncompatibleDataException;
import net.jqwik.engine.support.JqwikStringSupport;
import net.jqwik.engine.support.MethodParameter;

public class SampleOnlyShrinkablesGenerator
implements ForAllParametersGenerator {
    private final List<MethodParameter> forAllParameters;
    private final List<Object> sample;
    private boolean generated = false;

    public SampleOnlyShrinkablesGenerator(List<MethodParameter> forAllParameters, List<Object> sample) {
        this.forAllParameters = forAllParameters;
        this.sample = sample;
    }

    @Override
    public boolean hasNext() {
        return !this.generated;
    }

    @Override
    public List<Shrinkable<Object>> next() {
        if (this.generated) {
            throw new NoSuchElementException("Sample has already been provided");
        }
        this.checkCompatibility(this.sample);
        this.generated = true;
        return this.sample.stream().map(Shrinkable::unshrinkable).collect(Collectors.toList());
    }

    private void checkCompatibility(List<Object> sample) {
        if (sample.size() != this.forAllParameters.size()) {
            throw new IncompatibleDataException(this.createIncompatibilityMessage(sample));
        }
        for (int i = 0; i < sample.size(); ++i) {
            TypeUsage parameterType;
            TypeUsage valueType = TypeUsage.of(sample.get(i).getClass(), (TypeUsage[])new TypeUsage[0]);
            if (valueType.canBeAssignedTo(parameterType = TypeUsageImpl.forParameter(this.forAllParameters.get(i)))) continue;
            throw new IncompatibleDataException(this.createIncompatibilityMessage(sample));
        }
    }

    private String createIncompatibilityMessage(List<Object> sample) {
        List parameterTypes = this.forAllParameters.stream().map(TypeUsageImpl::forParameter).collect(Collectors.toList());
        return String.format("Sample %s is not compatible with parameters %s", JqwikStringSupport.displayString(sample), JqwikStringSupport.displayString(parameterTypes));
    }
}

