/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Consumer;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.IntegralGeneratingArbitrary;
import net.jqwik.engine.properties.arbitraries.MappedEdgeCasesConsumer;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;

public class DefaultLongArbitrary
extends TypedCloneable
implements LongArbitrary {
    private static final long DEFAULT_MIN = Long.MIN_VALUE;
    private static final long DEFAULT_MAX = Long.MAX_VALUE;
    private IntegralGeneratingArbitrary generatingArbitrary = new IntegralGeneratingArbitrary(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE));

    public RandomGenerator<Long> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize).map(BigInteger::longValueExact);
    }

    public Optional<ExhaustiveGenerator<Long>> exhaustive(long maxNumberOfSamples) {
        return this.generatingArbitrary.exhaustive(maxNumberOfSamples).map(generator -> generator.map(BigInteger::longValueExact));
    }

    public EdgeCases<Long> edgeCases(int maxEdgeCases) {
        return EdgeCasesSupport.map(this.generatingArbitrary.edgeCases(maxEdgeCases), BigInteger::longValueExact);
    }

    public Arbitrary<Long> edgeCases(Consumer<EdgeCases.Config<Long>> configurator) {
        MappedEdgeCasesConsumer<Long, BigInteger> integralConfigurator = new MappedEdgeCasesConsumer<Long, BigInteger>(configurator, BigInteger::longValueExact, BigInteger::valueOf);
        DefaultLongArbitrary clone = (DefaultLongArbitrary)this.typedClone();
        clone.generatingArbitrary = (IntegralGeneratingArbitrary)this.generatingArbitrary.edgeCases(integralConfigurator);
        return clone;
    }

    public LongArbitrary withDistribution(RandomDistribution distribution) {
        DefaultLongArbitrary clone = (DefaultLongArbitrary)this.typedClone();
        clone.generatingArbitrary.distribution = distribution;
        return clone;
    }

    public LongArbitrary greaterOrEqual(long min) {
        DefaultLongArbitrary clone = (DefaultLongArbitrary)this.typedClone();
        clone.generatingArbitrary.min = BigInteger.valueOf(min);
        return clone;
    }

    public LongArbitrary lessOrEqual(long max) {
        DefaultLongArbitrary clone = (DefaultLongArbitrary)this.typedClone();
        clone.generatingArbitrary.max = BigInteger.valueOf(max);
        return clone;
    }

    public LongArbitrary shrinkTowards(long target) {
        DefaultLongArbitrary clone = (DefaultLongArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = BigInteger.valueOf(target);
        return clone;
    }
}

