/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.arbitraries.StreamableArbitrary;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.UniquenessChecker;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

abstract class MultivalueArbitraryBase<T, U>
extends TypedCloneable
implements StreamableArbitrary<T, U> {
    protected Arbitrary<T> elementArbitrary;
    protected int minSize = 0;
    protected int maxSize = 255;
    protected Set<FeatureExtractor<T>> uniquenessExtractors = new HashSet<FeatureExtractor<T>>();

    protected MultivalueArbitraryBase(Arbitrary<T> elementArbitrary) {
        this.elementArbitrary = elementArbitrary;
    }

    public StreamableArbitrary<T, U> ofMinSize(int minSize) {
        MultivalueArbitraryBase clone = (MultivalueArbitraryBase)this.typedClone();
        clone.minSize = minSize;
        return clone;
    }

    public StreamableArbitrary<T, U> ofMaxSize(int maxSize) {
        MultivalueArbitraryBase clone = (MultivalueArbitraryBase)this.typedClone();
        clone.maxSize = maxSize;
        return clone;
    }

    public <R> Arbitrary<R> reduce(R initial, BiFunction<R, T, R> accumulator) {
        return this.map(streamable -> {
            Object[] result = new Object[]{initial};
            Iterable<T> iterable = this.toIterable(streamable);
            for (T each : iterable) {
                result[0] = accumulator.apply(result[0], each);
            }
            return result[0];
        });
    }

    protected abstract Iterable<T> toIterable(U var1);

    protected StreamableArbitrary<T, U> uniqueElements(FeatureExtractor<T> by) {
        MultivalueArbitraryBase clone = (MultivalueArbitraryBase)this.typedClone();
        clone.uniquenessExtractors = new HashSet<FeatureExtractor<T>>(this.uniquenessExtractors);
        clone.uniquenessExtractors.add(by);
        return clone;
    }

    protected RandomGenerator<List<T>> createListGenerator(int genSize, boolean withEmbeddedEdgeCases) {
        RandomGenerator<T> elementGenerator = this.elementGenerator(this.elementArbitrary, genSize, withEmbeddedEdgeCases);
        return RandomGenerators.list(elementGenerator, this.minSize, this.maxSize, this.uniquenessExtractors, this.cutoffSize(genSize));
    }

    protected int cutoffSize(int genSize) {
        return RandomGenerators.defaultCutoffSize(this.minSize, this.maxSize, genSize);
    }

    protected RandomGenerator<T> elementGenerator(Arbitrary<T> elementArbitrary, int genSize, boolean withEdgeCases) {
        return elementArbitrary.generator(genSize, withEdgeCases);
    }

    protected <C extends Collection<?>> EdgeCases<C> edgeCases(BiFunction<List<Shrinkable<T>>, Integer, Shrinkable<C>> shrinkableCreator, int maxEdgeCases) {
        EdgeCases<C> emptyListEdgeCase = this.minSize == 0 ? this.emptyListEdgeCase(shrinkableCreator) : EdgeCases.none();
        int effectiveMaxEdgeCases = maxEdgeCases - emptyListEdgeCase.size();
        EdgeCases<C> singleElementEdgeCases = this.minSize <= 1 && this.maxSize >= 1 ? this.fixedSizeEdgeCases(1, shrinkableCreator, effectiveMaxEdgeCases) : EdgeCases.none();
        effectiveMaxEdgeCases = maxEdgeCases - singleElementEdgeCases.size();
        EdgeCases<C> fixedSizeEdgeCases = this.generateFixedSizeEdgeCases() ? this.fixedSizeEdgeCases(this.minSize, shrinkableCreator, effectiveMaxEdgeCases) : EdgeCases.none();
        return EdgeCasesSupport.concat(Arrays.asList(emptyListEdgeCase, singleElementEdgeCases, fixedSizeEdgeCases), maxEdgeCases);
    }

    private boolean generateFixedSizeEdgeCases() {
        return this.minSize == this.maxSize && this.minSize > 1;
    }

    private <C extends Collection<?>> EdgeCases<C> fixedSizeEdgeCases(int fixedSize, BiFunction<List<Shrinkable<T>>, Integer, Shrinkable<C>> shrinkableCreator, int maxEdgeCases) {
        return EdgeCasesSupport.mapShrinkable(this.elementArbitrary.edgeCases(maxEdgeCases), shrinkableT -> {
            ArrayList elements = new ArrayList(Collections.nCopies(fixedSize, shrinkableT));
            if (!UniquenessChecker.checkUniquenessOfShrinkables(this.uniquenessExtractors, elements)) {
                return null;
            }
            return (Shrinkable)shrinkableCreator.apply(elements, this.minSize);
        });
    }

    private <C extends Collection<?>> EdgeCases<C> emptyListEdgeCase(BiFunction<List<Shrinkable<T>>, Integer, Shrinkable<C>> shrinkableCreator) {
        return EdgeCases.fromSupplier(() -> (Shrinkable)shrinkableCreator.apply(Collections.emptyList(), this.minSize));
    }
}

