/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.MaxTriesLoop;
import net.jqwik.engine.properties.UniquenessChecker;

class ContainerGenerator<T, C>
implements RandomGenerator<C> {
    private final RandomGenerator<T> elementGenerator;
    private final Function<List<Shrinkable<T>>, Shrinkable<C>> createShrinkable;
    private final int minSize;
    private final int cutoffSize;
    private final Collection<FeatureExtractor<T>> uniquenessExtractors;
    private Function<Random, Integer> sizeGenerator;

    private static Function<Random, Integer> sizeGenerator(int minSize, int maxSize, int cutoffSize) {
        if (cutoffSize >= maxSize) {
            return random -> ContainerGenerator.randomSize(random, minSize, maxSize);
        }
        return random -> {
            if (random.nextDouble() > 0.1) {
                return ContainerGenerator.randomSize(random, minSize, cutoffSize);
            }
            return ContainerGenerator.randomSize(random, cutoffSize + 1, maxSize);
        };
    }

    private static int randomSize(Random random, int minSize, int maxSize) {
        int range = maxSize - minSize;
        return random.nextInt(range + 1) + minSize;
    }

    ContainerGenerator(RandomGenerator<T> elementGenerator, Function<List<Shrinkable<T>>, Shrinkable<C>> createShrinkable, int minSize, int maxSize, int cutoffSize, Collection<FeatureExtractor<T>> uniquenessExtractors) {
        this.elementGenerator = elementGenerator;
        this.createShrinkable = createShrinkable;
        this.minSize = minSize;
        this.cutoffSize = cutoffSize;
        this.uniquenessExtractors = uniquenessExtractors;
        this.sizeGenerator = ContainerGenerator.sizeGenerator(minSize, maxSize, cutoffSize);
    }

    public Shrinkable<C> next(Random random) {
        int listSize = this.sizeGenerator.apply(random);
        ArrayList listOfShrinkables = new ArrayList();
        ArrayList existingValues = new ArrayList();
        while (listOfShrinkables.size() < listSize) {
            try {
                Shrinkable next = this.nextUntilAccepted(random, existingValues, arg_0 -> this.elementGenerator.next(arg_0));
                listOfShrinkables.add(next);
            }
            catch (TooManyFilterMissesException tooManyFilterMissesException) {
                if (listOfShrinkables.size() < this.minSize) {
                    throw tooManyFilterMissesException;
                }
                listSize = listOfShrinkables.size();
                this.sizeGenerator = ContainerGenerator.sizeGenerator(this.minSize, listSize, this.cutoffSize);
            }
        }
        return this.createShrinkable.apply(listOfShrinkables);
    }

    private Shrinkable<T> nextUntilAccepted(Random random, List<T> existingValues, Function<Random, Shrinkable<T>> fetchShrinkable) {
        Shrinkable accepted = MaxTriesLoop.loop(() -> true, next -> {
            next = (Shrinkable)fetchShrinkable.apply(random);
            Object value = next.value();
            if (this.checkUniqueness(existingValues, value)) {
                existingValues.add(value);
                return Tuple.of((Object)true, (Object)next);
            }
            return Tuple.of((Object)false, (Object)next);
        }, maxMisses -> {
            String message = String.format("Trying to fulfill uniqueness constraint missed more than %s times.", maxMisses);
            return new TooManyFilterMissesException(message);
        });
        return accepted;
    }

    private boolean checkUniqueness(List<T> elements, T value) {
        return UniquenessChecker.checkValueUniqueIn(this.uniquenessExtractors, value, elements);
    }
}

