/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.randomized.RandomIntegralGenerators;

public class RandomDecimalGenerators {
    public static RandomGenerator<BigDecimal> bigDecimals(int genSize, Range<BigDecimal> range, int scale, RandomDistribution distribution, BigDecimal shrinkingTarget) {
        RandomDecimalGenerators.checkRangeIsSound(range, scale);
        if (scale < 0) {
            throw new JqwikException(String.format("Scale [%s] must be positive.", scale));
        }
        if (range.isSingular()) {
            return ignored -> Shrinkable.unshrinkable((Object)((BigDecimal)range.min));
        }
        Range<BigInteger> unscaledRange = RandomDecimalGenerators.unscaledBigIntegerRange(range, scale);
        BigInteger unscaledShrinkingTarget = RandomDecimalGenerators.unscaledBigInteger(shrinkingTarget, scale);
        RandomGenerator<BigInteger> unscaledBigIntegerGenerator = RandomIntegralGenerators.bigIntegers(genSize, (BigInteger)unscaledRange.min, (BigInteger)unscaledRange.max, unscaledShrinkingTarget, distribution);
        return RandomDecimalGenerators.scaledBigDecimalGenerator(unscaledBigIntegerGenerator, scale);
    }

    private static void checkRangeIsSound(Range<BigDecimal> range, int scale) {
        if (range.minIncluded || range.maxIncluded) {
            return;
        }
        BigDecimal minimumDifference = BigDecimal.ONE.movePointLeft(scale);
        if (((BigDecimal)range.min).add(minimumDifference).compareTo((BigDecimal)range.max) >= 0) {
            String message = String.format("No number with scale <%s> can be generated in %s", scale, range);
            throw new JqwikException(message);
        }
    }

    private static RandomGenerator<BigDecimal> scaledBigDecimalGenerator(RandomGenerator<BigInteger> scaledBigIntegerGenerator, int scale) {
        return scaledBigIntegerGenerator.map(value -> RandomDecimalGenerators.scaledBigDecimal(value, scale));
    }

    public static Range<BigInteger> unscaledBigIntegerRange(Range<BigDecimal> range, int scale) {
        BigInteger minScaled = range.minIncluded ? RandomDecimalGenerators.unscaledBigInteger((BigDecimal)range.min, scale) : RandomDecimalGenerators.unscaledBigInteger((BigDecimal)range.min, scale).add(BigInteger.ONE);
        BigInteger maxScaled = range.maxIncluded ? RandomDecimalGenerators.unscaledBigInteger((BigDecimal)range.max, scale) : RandomDecimalGenerators.unscaledBigInteger((BigDecimal)range.max, scale).subtract(BigInteger.ONE);
        return Range.of(minScaled, true, maxScaled, true);
    }

    public static BigDecimal scaledBigDecimal(BigInteger value, int scale) {
        return new BigDecimal(value, scale);
    }

    public static BigInteger unscaledBigInteger(BigDecimal bigDecimal, int scale) {
        return bigDecimal.setScale(scale, 4).unscaledValue();
    }

    public static BigDecimal defaultShrinkingTarget(Range<BigDecimal> range, int scale) {
        if (range.includes(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        if (((BigDecimal)range.max).compareTo(BigDecimal.ZERO) <= 0) {
            if (range.maxIncluded) {
                return (BigDecimal)range.max;
            }
            BigDecimal minimumDifference = BigDecimal.ONE.movePointLeft(scale);
            return ((BigDecimal)range.max).subtract(minimumDifference);
        }
        if (((BigDecimal)range.min).compareTo(BigDecimal.ZERO) >= 0) {
            if (range.minIncluded) {
                return (BigDecimal)range.min;
            }
            BigDecimal minimumDifference = BigDecimal.ONE.movePointLeft(scale);
            return ((BigDecimal)range.min).add(minimumDifference);
        }
        throw new RuntimeException("This should not be possible");
    }
}

